/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.TempDirectory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PathUtilsIsEmptyTest {
    public static final Path DIR_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1", new String[0]);
    private static final Path FILE_SIZE_0 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]);
    private static final Path FILE_SIZE_1 = Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]);

    PathUtilsIsEmptyTest() {
    }

    @Test
    void testIsEmpty() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmpty((Path)FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmpty((Path)FILE_SIZE_1));
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            Assertions.assertTrue((boolean)PathUtils.isEmpty((Path)tempDir.get()));
        }
        Assertions.assertFalse((boolean)PathUtils.isEmpty((Path)DIR_SIZE_1));
    }

    @Test
    void testIsEmptyDirectory() throws IOException {
        try (TempDirectory tempDir = TempDirectory.create(this.getClass().getCanonicalName(), new FileAttribute[0]);){
            Assertions.assertTrue((boolean)PathUtils.isEmptyDirectory((Path)tempDir.get()));
        }
        Assertions.assertFalse((boolean)PathUtils.isEmptyDirectory((Path)DIR_SIZE_1));
    }

    @Test
    void testisEmptyFile() throws IOException {
        Assertions.assertTrue((boolean)PathUtils.isEmptyFile((Path)FILE_SIZE_0));
        Assertions.assertFalse((boolean)PathUtils.isEmptyFile((Path)FILE_SIZE_1));
    }
}

