/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v139.network.model.AlternateProtocolUsage;
import org.openqa.selenium.devtools.v139.network.model.Headers;
import org.openqa.selenium.devtools.v139.network.model.ResourceTiming;
import org.openqa.selenium.devtools.v139.network.model.SecurityDetails;
import org.openqa.selenium.devtools.v139.network.model.ServiceWorkerResponseSource;
import org.openqa.selenium.devtools.v139.network.model.ServiceWorkerRouterInfo;
import org.openqa.selenium.devtools.v139.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v139.security.model.SecurityState;
import org.openqa.selenium.json.JsonInput;

public class Response {
    private final String url;
    private final Integer status;
    private final String statusText;
    private final Headers headers;
    private final Optional<String> headersText;
    private final String mimeType;
    private final String charset;
    private final Optional<Headers> requestHeaders;
    private final Optional<String> requestHeadersText;
    private final Boolean connectionReused;
    private final Number connectionId;
    private final Optional<String> remoteIPAddress;
    private final Optional<Integer> remotePort;
    private final Optional<Boolean> fromDiskCache;
    private final Optional<Boolean> fromServiceWorker;
    private final Optional<Boolean> fromPrefetchCache;
    private final Optional<Boolean> fromEarlyHints;
    private final Optional<ServiceWorkerRouterInfo> serviceWorkerRouterInfo;
    private final Number encodedDataLength;
    private final Optional<ResourceTiming> timing;
    private final Optional<ServiceWorkerResponseSource> serviceWorkerResponseSource;
    private final Optional<TimeSinceEpoch> responseTime;
    private final Optional<String> cacheStorageCacheName;
    private final Optional<String> protocol;
    private final Optional<AlternateProtocolUsage> alternateProtocolUsage;
    private final SecurityState securityState;
    private final Optional<SecurityDetails> securityDetails;

    public Response(String url, Integer status, String statusText, Headers headers, Optional<String> headersText, String mimeType, String charset, Optional<Headers> requestHeaders, Optional<String> requestHeadersText, Boolean connectionReused, Number connectionId, Optional<String> remoteIPAddress, Optional<Integer> remotePort, Optional<Boolean> fromDiskCache, Optional<Boolean> fromServiceWorker, Optional<Boolean> fromPrefetchCache, Optional<Boolean> fromEarlyHints, Optional<ServiceWorkerRouterInfo> serviceWorkerRouterInfo, Number encodedDataLength, Optional<ResourceTiming> timing, Optional<ServiceWorkerResponseSource> serviceWorkerResponseSource, Optional<TimeSinceEpoch> responseTime, Optional<String> cacheStorageCacheName, Optional<String> protocol, Optional<AlternateProtocolUsage> alternateProtocolUsage, SecurityState securityState, Optional<SecurityDetails> securityDetails) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.statusText = Objects.requireNonNull(statusText, "statusText is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.headersText = headersText;
        this.mimeType = Objects.requireNonNull(mimeType, "mimeType is required");
        this.charset = Objects.requireNonNull(charset, "charset is required");
        this.requestHeaders = requestHeaders;
        this.requestHeadersText = requestHeadersText;
        this.connectionReused = Objects.requireNonNull(connectionReused, "connectionReused is required");
        this.connectionId = Objects.requireNonNull(connectionId, "connectionId is required");
        this.remoteIPAddress = remoteIPAddress;
        this.remotePort = remotePort;
        this.fromDiskCache = fromDiskCache;
        this.fromServiceWorker = fromServiceWorker;
        this.fromPrefetchCache = fromPrefetchCache;
        this.fromEarlyHints = fromEarlyHints;
        this.serviceWorkerRouterInfo = serviceWorkerRouterInfo;
        this.encodedDataLength = Objects.requireNonNull(encodedDataLength, "encodedDataLength is required");
        this.timing = timing;
        this.serviceWorkerResponseSource = serviceWorkerResponseSource;
        this.responseTime = responseTime;
        this.cacheStorageCacheName = cacheStorageCacheName;
        this.protocol = protocol;
        this.alternateProtocolUsage = alternateProtocolUsage;
        this.securityState = Objects.requireNonNull(securityState, "securityState is required");
        this.securityDetails = securityDetails;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    @Deprecated
    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getCharset() {
        return this.charset;
    }

    public Optional<Headers> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Deprecated
    public Optional<String> getRequestHeadersText() {
        return this.requestHeadersText;
    }

    public Boolean getConnectionReused() {
        return this.connectionReused;
    }

    public Number getConnectionId() {
        return this.connectionId;
    }

    public Optional<String> getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    public Optional<Boolean> getFromDiskCache() {
        return this.fromDiskCache;
    }

    public Optional<Boolean> getFromServiceWorker() {
        return this.fromServiceWorker;
    }

    public Optional<Boolean> getFromPrefetchCache() {
        return this.fromPrefetchCache;
    }

    public Optional<Boolean> getFromEarlyHints() {
        return this.fromEarlyHints;
    }

    @Beta
    public Optional<ServiceWorkerRouterInfo> getServiceWorkerRouterInfo() {
        return this.serviceWorkerRouterInfo;
    }

    public Number getEncodedDataLength() {
        return this.encodedDataLength;
    }

    public Optional<ResourceTiming> getTiming() {
        return this.timing;
    }

    public Optional<ServiceWorkerResponseSource> getServiceWorkerResponseSource() {
        return this.serviceWorkerResponseSource;
    }

    public Optional<TimeSinceEpoch> getResponseTime() {
        return this.responseTime;
    }

    public Optional<String> getCacheStorageCacheName() {
        return this.cacheStorageCacheName;
    }

    public Optional<String> getProtocol() {
        return this.protocol;
    }

    @Beta
    public Optional<AlternateProtocolUsage> getAlternateProtocolUsage() {
        return this.alternateProtocolUsage;
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public Optional<SecurityDetails> getSecurityDetails() {
        return this.securityDetails;
    }

    private static Response fromJson(JsonInput input) {
        String url = null;
        Integer status = 0;
        String statusText = null;
        Headers headers = null;
        Optional<String> headersText = Optional.empty();
        String mimeType = null;
        String charset = null;
        Optional<Headers> requestHeaders = Optional.empty();
        Optional<String> requestHeadersText = Optional.empty();
        Boolean connectionReused = false;
        Number connectionId = 0;
        Optional<String> remoteIPAddress = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        Optional<Boolean> fromDiskCache = Optional.empty();
        Optional<Boolean> fromServiceWorker = Optional.empty();
        Optional<Boolean> fromPrefetchCache = Optional.empty();
        Optional<Boolean> fromEarlyHints = Optional.empty();
        Optional<ServiceWorkerRouterInfo> serviceWorkerRouterInfo = Optional.empty();
        Number encodedDataLength = 0;
        Optional<ResourceTiming> timing = Optional.empty();
        Optional<ServiceWorkerResponseSource> serviceWorkerResponseSource = Optional.empty();
        Optional<TimeSinceEpoch> responseTime = Optional.empty();
        Optional<String> cacheStorageCacheName = Optional.empty();
        Optional<String> protocol = Optional.empty();
        Optional<AlternateProtocolUsage> alternateProtocolUsage = Optional.empty();
        SecurityState securityState = null;
        Optional<SecurityDetails> securityDetails = Optional.empty();
        input.beginObject();
        block58: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block58;
                }
                case "status": {
                    status = input.nextNumber().intValue();
                    continue block58;
                }
                case "statusText": {
                    statusText = input.nextString();
                    continue block58;
                }
                case "headers": {
                    headers = (Headers)input.read(Headers.class);
                    continue block58;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block58;
                }
                case "mimeType": {
                    mimeType = input.nextString();
                    continue block58;
                }
                case "charset": {
                    charset = input.nextString();
                    continue block58;
                }
                case "requestHeaders": {
                    requestHeaders = Optional.ofNullable((Headers)input.read(Headers.class));
                    continue block58;
                }
                case "requestHeadersText": {
                    requestHeadersText = Optional.ofNullable(input.nextString());
                    continue block58;
                }
                case "connectionReused": {
                    connectionReused = input.nextBoolean();
                    continue block58;
                }
                case "connectionId": {
                    connectionId = input.nextNumber();
                    continue block58;
                }
                case "remoteIPAddress": {
                    remoteIPAddress = Optional.ofNullable(input.nextString());
                    continue block58;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block58;
                }
                case "fromDiskCache": {
                    fromDiskCache = Optional.ofNullable(input.nextBoolean());
                    continue block58;
                }
                case "fromServiceWorker": {
                    fromServiceWorker = Optional.ofNullable(input.nextBoolean());
                    continue block58;
                }
                case "fromPrefetchCache": {
                    fromPrefetchCache = Optional.ofNullable(input.nextBoolean());
                    continue block58;
                }
                case "fromEarlyHints": {
                    fromEarlyHints = Optional.ofNullable(input.nextBoolean());
                    continue block58;
                }
                case "serviceWorkerRouterInfo": {
                    serviceWorkerRouterInfo = Optional.ofNullable((ServiceWorkerRouterInfo)input.read(ServiceWorkerRouterInfo.class));
                    continue block58;
                }
                case "encodedDataLength": {
                    encodedDataLength = input.nextNumber();
                    continue block58;
                }
                case "timing": {
                    timing = Optional.ofNullable((ResourceTiming)input.read(ResourceTiming.class));
                    continue block58;
                }
                case "serviceWorkerResponseSource": {
                    serviceWorkerResponseSource = Optional.ofNullable((ServiceWorkerResponseSource)((Object)input.read(ServiceWorkerResponseSource.class)));
                    continue block58;
                }
                case "responseTime": {
                    responseTime = Optional.ofNullable((TimeSinceEpoch)input.read(TimeSinceEpoch.class));
                    continue block58;
                }
                case "cacheStorageCacheName": {
                    cacheStorageCacheName = Optional.ofNullable(input.nextString());
                    continue block58;
                }
                case "protocol": {
                    protocol = Optional.ofNullable(input.nextString());
                    continue block58;
                }
                case "alternateProtocolUsage": {
                    alternateProtocolUsage = Optional.ofNullable((AlternateProtocolUsage)((Object)input.read(AlternateProtocolUsage.class)));
                    continue block58;
                }
                case "securityState": {
                    securityState = (SecurityState)((Object)input.read(SecurityState.class));
                    continue block58;
                }
                case "securityDetails": {
                    securityDetails = Optional.ofNullable((SecurityDetails)input.read(SecurityDetails.class));
                    continue block58;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Response(url, status, statusText, headers, headersText, mimeType, charset, requestHeaders, requestHeadersText, connectionReused, connectionId, remoteIPAddress, remotePort, fromDiskCache, fromServiceWorker, fromPrefetchCache, fromEarlyHints, serviceWorkerRouterInfo, encodedDataLength, timing, serviceWorkerResponseSource, responseTime, cacheStorageCacheName, protocol, alternateProtocolUsage, securityState, securityDetails);
    }
}

