package org.openqa.selenium.devtools.v139.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of image types that can be disabled.
 */
@org.openqa.selenium.Beta()
public enum DisabledImageType {

    AVIF("avif"), WEBP("webp");

    private String value;

    DisabledImageType(String value) {
        this.value = value;
    }

    public static DisabledImageType fromString(String s) {
        return java.util.Arrays.stream(DisabledImageType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DisabledImageType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DisabledImageType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
