package org.openqa.selenium.devtools.v139.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class CustomPreview {

    private final java.lang.String header;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId> bodyGetterId;

    public CustomPreview(java.lang.String header, java.util.Optional<org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId> bodyGetterId) {
        this.header = java.util.Objects.requireNonNull(header, "header is required");
        this.bodyGetterId = bodyGetterId;
    }

    /**
     * The JSON-stringified result of formatter.header(object, config) call.
     * It contains json ML array that represents RemoteObject.
     */
    public java.lang.String getHeader() {
        return header;
    }

    /**
     * If formatter returns true as a result of formatter.hasBody call then bodyGetterId will
     * contain RemoteObjectId for the function that returns result of formatter.body(object, config) call.
     * The result value is json ML array.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId> getBodyGetterId() {
        return bodyGetterId;
    }

    private static CustomPreview fromJson(JsonInput input) {
        java.lang.String header = null;
        java.util.Optional<org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId> bodyGetterId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "header":
                    header = input.nextString();
                    break;
                case "bodyGetterId":
                    bodyGetterId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.runtime.model.RemoteObjectId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CustomPreview(header, bodyGetterId);
    }
}
