/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.LogRecordExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogLimitsBuilder;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessorBuilder;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class LoggerProviderConfiguration {
    private static final List<String> simpleProcessorExporterNames = Arrays.asList("console", "logging");

    static void configureLoggerProvider(SdkLoggerProviderBuilder loggerProviderBuilder, ConfigProperties config, SpiHelper spiHelper, MeterProvider meterProvider, BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer, BiFunction<? super LogRecordProcessor, ConfigProperties, ? extends LogRecordProcessor> logRecordProcessorCustomizer, List<Closeable> closeables) {
        loggerProviderBuilder.setLogLimits(() -> LoggerProviderConfiguration.configureLogLimits(config));
        Map<String, LogRecordExporter> exportersByName = LogRecordExporterConfiguration.configureLogRecordExporters(config, spiHelper, logRecordExporterCustomizer, closeables);
        List<LogRecordProcessor> processors = LoggerProviderConfiguration.configureLogRecordProcessors(config, exportersByName, meterProvider, closeables);
        for (LogRecordProcessor processor : processors) {
            LogRecordProcessor wrapped = logRecordProcessorCustomizer.apply((LogRecordProcessor)processor, config);
            if (wrapped != processor) {
                closeables.add((Closeable)wrapped);
            }
            loggerProviderBuilder.addLogRecordProcessor(wrapped);
        }
    }

    static List<LogRecordProcessor> configureLogRecordProcessors(ConfigProperties config, Map<String, LogRecordExporter> exportersByName, MeterProvider meterProvider, List<Closeable> closeables) {
        HashMap<String, LogRecordExporter> exportersByNameCopy = new HashMap<String, LogRecordExporter>(exportersByName);
        ArrayList<LogRecordProcessor> logRecordProcessors = new ArrayList<LogRecordProcessor>();
        for (String simpleProcessorExporterName : simpleProcessorExporterNames) {
            LogRecordExporter exporter = (LogRecordExporter)exportersByNameCopy.remove(simpleProcessorExporterName);
            if (exporter == null) continue;
            LogRecordProcessor logRecordProcessor = SimpleLogRecordProcessor.create((LogRecordExporter)exporter);
            closeables.add((Closeable)logRecordProcessor);
            logRecordProcessors.add(logRecordProcessor);
        }
        if (!exportersByNameCopy.isEmpty()) {
            LogRecordExporter compositeLogRecordExporter = LogRecordExporter.composite(exportersByNameCopy.values());
            BatchLogRecordProcessor logRecordProcessor = LoggerProviderConfiguration.configureBatchLogRecordProcessor(config, compositeLogRecordExporter, meterProvider);
            closeables.add((Closeable)logRecordProcessor);
            logRecordProcessors.add((LogRecordProcessor)logRecordProcessor);
        }
        return logRecordProcessors;
    }

    static BatchLogRecordProcessor configureBatchLogRecordProcessor(ConfigProperties config, LogRecordExporter exporter, MeterProvider meterProvider) {
        Duration timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchLogRecordProcessorBuilder builder = BatchLogRecordProcessor.builder((LogRecordExporter)exporter).setMeterProvider(meterProvider);
        Duration scheduleDelay = config.getDuration("otel.blrp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.blrp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue.intValue());
        }
        if ((maxExportBatch = config.getInt("otel.blrp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch.intValue());
        }
        if ((timeout = config.getDuration("otel.blrp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout);
        }
        return builder.build();
    }

    static LogLimits configureLogLimits(ConfigProperties config) {
        Integer maxAttrs;
        LogLimitsBuilder builder = LogLimits.builder();
        Integer maxAttrLength = config.getInt("otel.attribute.value.length.limit");
        if (maxAttrLength != null) {
            builder.setMaxAttributeValueLength(maxAttrLength.intValue());
        }
        if ((maxAttrs = config.getInt("otel.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs.intValue());
        }
        return builder.build();
    }

    private LoggerProviderConfiguration() {
    }
}

