/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CountingInputStreamTest {
    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterClose(int len) throws Exception {
        CloseShieldInputStream shadow;
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap(bais);){
            Assertions.assertEquals((int)len, (int)((InputStream)in).available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)shadow).available());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testAvailableAfterOpen(int len) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap(bais);){
            Assertions.assertEquals((int)len, (int)((InputStream)in).available());
        }
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(new CountingInputStream(new BrokenInputStream((Throwable)new IOException())));
    }

    @Test
    public void testCounting() throws Exception {
        String text = "A piece of text";
        try (CountingInputStream cis = new CountingInputStream(((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("A piece of text")).get());){
            byte[] result = new byte[21];
            byte[] ba = new byte[5];
            int found = cis.read(ba);
            System.arraycopy(ba, 0, result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int value = cis.read();
            result[5] = (byte)value;
            Assertions.assertEquals((int)(++found), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 6, 5)), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 11, 10)), (int)cis.getCount());
            String textResult = new String(result).trim();
            Assertions.assertEquals((Object)textResult, (Object)"A piece of text");
        }
    }

    @Test
    public void testEOF1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            int found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)1, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testEOF2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testEOF3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        CountingInputStream cis = new CountingInputStream(mock);
        IOUtils.consume(cis);
        Assertions.assertThrows(ArithmeticException.class, () -> cis.getCount());
        Assertions.assertThrows(ArithmeticException.class, () -> cis.resetCount());
        mock.init();
        IOUtils.consume(cis);
        Assertions.assertEquals((long)0x80000000L, (long)cis.getByteCount(), (String)"getByteCount()");
        Assertions.assertEquals((long)0x80000000L, (long)cis.resetByteCount(), (String)"resetByteCount()");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.input.AbstractInputStreamTest#getArrayLengths"})
    public void testReadAfterClose(int len) throws Exception {
        CloseShieldInputStream shadow;
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[len]);
        try (CloseShieldInputStream in = CloseShieldInputStream.wrap(bais);){
            Assertions.assertEquals((int)len, (int)((InputStream)in).available());
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)shadow).read());
    }

    @Test
    public void testResetting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            byte[] result = new byte[bytes.length];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int count = cis.resetCount();
            found = cis.read(result, 6, 5);
            Assertions.assertEquals((int)found, (int)count);
        }
    }

    @Test
    public void testSkipping() throws IOException {
        String text = "Hello World!";
        try (CountingInputStream cis = new CountingInputStream(((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("Hello World!")).get());){
            Assertions.assertEquals((long)6L, (long)cis.skip(6L));
            Assertions.assertEquals((int)6, (int)cis.getCount());
            byte[] result = new byte[6];
            Assertions.assertEquals((int)result.length, (int)cis.read(result));
            Assertions.assertEquals((Object)"World!", (Object)new String(result));
            Assertions.assertEquals((int)12, (int)cis.getCount());
        }
    }

    @Test
    public void testZeroLength1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            int found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    public void testZeroLength2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    public void testZeroLength3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);
        try (CountingInputStream cis = new CountingInputStream(bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }
}

