/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.css.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v133.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v133.css.model.CSSLayer;
import org.openqa.selenium.devtools.v133.css.model.CSSMedia;
import org.openqa.selenium.devtools.v133.css.model.CSSRuleType;
import org.openqa.selenium.devtools.v133.css.model.CSSScope;
import org.openqa.selenium.devtools.v133.css.model.CSSStartingStyle;
import org.openqa.selenium.devtools.v133.css.model.CSSStyle;
import org.openqa.selenium.devtools.v133.css.model.CSSSupports;
import org.openqa.selenium.devtools.v133.css.model.SelectorList;
import org.openqa.selenium.devtools.v133.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v133.css.model.StyleSheetOrigin;
import org.openqa.selenium.json.JsonInput;

public class CSSRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final SelectorList selectorList;
    private final Optional<List<String>> nestingSelectors;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final Optional<List<CSSMedia>> media;
    private final Optional<List<CSSContainerQuery>> containerQueries;
    private final Optional<List<CSSSupports>> supports;
    private final Optional<List<CSSLayer>> layers;
    private final Optional<List<CSSScope>> scopes;
    private final Optional<List<CSSRuleType>> ruleTypes;
    private final Optional<List<CSSStartingStyle>> startingStyles;

    public CSSRule(Optional<StyleSheetId> styleSheetId, SelectorList selectorList, Optional<List<String>> nestingSelectors, StyleSheetOrigin origin, CSSStyle style, Optional<List<CSSMedia>> media, Optional<List<CSSContainerQuery>> containerQueries, Optional<List<CSSSupports>> supports, Optional<List<CSSLayer>> layers, Optional<List<CSSScope>> scopes, Optional<List<CSSRuleType>> ruleTypes, Optional<List<CSSStartingStyle>> startingStyles) {
        this.styleSheetId = styleSheetId;
        this.selectorList = Objects.requireNonNull(selectorList, "selectorList is required");
        this.nestingSelectors = nestingSelectors;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.layers = layers;
        this.scopes = scopes;
        this.ruleTypes = ruleTypes;
        this.startingStyles = startingStyles;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Beta
    public Optional<List<String>> getNestingSelectors() {
        return this.nestingSelectors;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public Optional<List<CSSMedia>> getMedia() {
        return this.media;
    }

    @Beta
    public Optional<List<CSSContainerQuery>> getContainerQueries() {
        return this.containerQueries;
    }

    @Beta
    public Optional<List<CSSSupports>> getSupports() {
        return this.supports;
    }

    @Beta
    public Optional<List<CSSLayer>> getLayers() {
        return this.layers;
    }

    @Beta
    public Optional<List<CSSScope>> getScopes() {
        return this.scopes;
    }

    @Beta
    public Optional<List<CSSRuleType>> getRuleTypes() {
        return this.ruleTypes;
    }

    @Beta
    public Optional<List<CSSStartingStyle>> getStartingStyles() {
        return this.startingStyles;
    }

    private static CSSRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        SelectorList selectorList = null;
        Optional<List<String>> nestingSelectors = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        Optional<List<CSSMedia>> media = Optional.empty();
        Optional<List<CSSContainerQuery>> containerQueries = Optional.empty();
        Optional<List<CSSSupports>> supports = Optional.empty();
        Optional<List<CSSLayer>> layers = Optional.empty();
        Optional<List<CSSScope>> scopes = Optional.empty();
        Optional<List<CSSRuleType>> ruleTypes = Optional.empty();
        Optional<List<CSSStartingStyle>> startingStyles = Optional.empty();
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read((Type)((Object)StyleSheetId.class)));
                    continue block28;
                }
                case "selectorList": {
                    selectorList = (SelectorList)input.read((Type)((Object)SelectorList.class));
                    continue block28;
                }
                case "nestingSelectors": {
                    nestingSelectors = Optional.ofNullable(input.readArray((Type)((Object)String.class)));
                    continue block28;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read((Type)((Object)StyleSheetOrigin.class)));
                    continue block28;
                }
                case "style": {
                    style = (CSSStyle)input.read((Type)((Object)CSSStyle.class));
                    continue block28;
                }
                case "media": {
                    media = Optional.ofNullable(input.readArray((Type)((Object)CSSMedia.class)));
                    continue block28;
                }
                case "containerQueries": {
                    containerQueries = Optional.ofNullable(input.readArray((Type)((Object)CSSContainerQuery.class)));
                    continue block28;
                }
                case "supports": {
                    supports = Optional.ofNullable(input.readArray((Type)((Object)CSSSupports.class)));
                    continue block28;
                }
                case "layers": {
                    layers = Optional.ofNullable(input.readArray((Type)((Object)CSSLayer.class)));
                    continue block28;
                }
                case "scopes": {
                    scopes = Optional.ofNullable(input.readArray((Type)((Object)CSSScope.class)));
                    continue block28;
                }
                case "ruleTypes": {
                    ruleTypes = Optional.ofNullable(input.readArray((Type)((Object)CSSRuleType.class)));
                    continue block28;
                }
                case "startingStyles": {
                    startingStyles = Optional.ofNullable(input.readArray((Type)((Object)CSSStartingStyle.class)));
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, nestingSelectors, origin, style, media, containerQueries, supports, layers, scopes, ruleTypes, startingStyles);
    }
}

