/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ClearSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;

    ClearSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueue = Require.nonNull("New Session Queue", newSessionQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse execute(HttpRequest req) {
        Tags.HTTP_REQUEST.accept(span, req);
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.clear");){
            int value = this.newSessionQueue.clearQueue();
            span.setAttribute("cleared", value);
            HttpResponse response = new HttpResponse();
            if (value != 0) {
                response.setContent(Contents.asJson(ImmutableMap.of("value", value, "message", "Cleared the new session request queue", "cleared_requests", value)));
            } else {
                response.setContent(Contents.asJson(ImmutableMap.of("value", value, "message", "New session request queue empty. Nothing to clear.")));
            }
            span.setAttribute("requests.cleared", value);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

