/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;

public class DesiredCapabilities
extends MutableCapabilities {
    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("browserVersion", version);
        this.setCapability("platformName", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap == null) {
            return;
        }
        rawMap.forEach(this::setCapability);
    }

    public DesiredCapabilities(Capabilities other) {
        this.merge(other);
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            this.merge(caps);
        }
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("browserVersion", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platformName", platform);
    }

    public boolean acceptInsecureCerts() {
        if (this.getCapability("acceptInsecureCerts") != null) {
            Object raw = this.getCapability("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    @Override
    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities != null) {
            extraCapabilities.asMap().forEach(this::setCapability);
        }
        return this;
    }
}

