/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.page.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v133.page.model.ImageResource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Screenshot {
    private final ImageResource image;
    private final String formFactor;
    private final Optional<String> label;

    public Screenshot(ImageResource image, String formFactor, Optional<String> label) {
        this.image = Objects.requireNonNull(image, "image is required");
        this.formFactor = Objects.requireNonNull(formFactor, "formFactor is required");
        this.label = label;
    }

    public ImageResource getImage() {
        return this.image;
    }

    public String getFormFactor() {
        return this.formFactor;
    }

    public Optional<String> getLabel() {
        return this.label;
    }

    private static Screenshot fromJson(JsonInput input) {
        ImageResource image = null;
        String formFactor = null;
        Optional<String> label = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "image": {
                    image = (ImageResource)input.read(ImageResource.class);
                    continue block10;
                }
                case "formFactor": {
                    formFactor = input.nextString();
                    continue block10;
                }
                case "label": {
                    label = Optional.ofNullable(input.nextString());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Screenshot(image, formFactor, label);
    }
}

