/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Pasteboard;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCImageFrame;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javax.imageio.ImageIO;

final class PasteboardImpl
implements Pasteboard {
    private final Clipboard clipboard = Clipboard.getSystemClipboard();

    PasteboardImpl() {
    }

    @Override
    public String getPlainText() {
        return this.clipboard.getString();
    }

    @Override
    public String getHtml() {
        return this.clipboard.getHtml();
    }

    @Override
    public void writePlainText(String string) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        this.clipboard.setContent(clipboardContent);
    }

    @Override
    public void writeSelection(boolean bl, String string, String string2) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        clipboardContent.putHtml(string2);
        this.clipboard.setContent(clipboardContent);
    }

    @Override
    public void writeImage(WCImageFrame wCImageFrame) {
        Image image;
        WCImage wCImage = wCImageFrame.getFrame();
        Image image2 = image = wCImage != null && !wCImage.isNull() ? Toolkit.getImageAccessor().fromPlatformImage(wCImage.getPlatformImage()) : null;
        if (image != null) {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putImage(image);
            String string = wCImage.getFileExtension();
            try {
                File file = File.createTempFile("jfx", "." + string);
                file.deleteOnExit();
                ImageIO.write((RenderedImage)wCImage.toBufferedImage(), string, file);
                clipboardContent.putFiles(Arrays.asList(file));
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
            this.clipboard.setContent(clipboardContent);
        }
    }

    @Override
    public void writeUrl(String string, String string2) {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(string);
        clipboardContent.putHtml(string2);
        clipboardContent.putUrl(string);
        this.clipboard.setContent(clipboardContent);
    }
}

