/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum CookieWarningReason {
    WARNSAMESITEUNSPECIFIEDCROSSSITECONTEXT("WarnSameSiteUnspecifiedCrossSiteContext"),
    WARNSAMESITENONEINSECURE("WarnSameSiteNoneInsecure"),
    WARNSAMESITEUNSPECIFIEDLAXALLOWUNSAFE("WarnSameSiteUnspecifiedLaxAllowUnsafe"),
    WARNSAMESITESTRICTLAXDOWNGRADESTRICT("WarnSameSiteStrictLaxDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADESTRICT("WarnSameSiteStrictCrossDowngradeStrict"),
    WARNSAMESITESTRICTCROSSDOWNGRADELAX("WarnSameSiteStrictCrossDowngradeLax"),
    WARNSAMESITELAXCROSSDOWNGRADESTRICT("WarnSameSiteLaxCrossDowngradeStrict"),
    WARNSAMESITELAXCROSSDOWNGRADELAX("WarnSameSiteLaxCrossDowngradeLax"),
    WARNATTRIBUTEVALUEEXCEEDSMAXSIZE("WarnAttributeValueExceedsMaxSize"),
    WARNDOMAINNONASCII("WarnDomainNonASCII"),
    WARNTHIRDPARTYPHASEOUT("WarnThirdPartyPhaseout"),
    WARNCROSSSITEREDIRECTDOWNGRADECHANGESINCLUSION("WarnCrossSiteRedirectDowngradeChangesInclusion"),
    WARNDEPRECATIONTRIALMETADATA("WarnDeprecationTrialMetadata"),
    WARNTHIRDPARTYCOOKIEHEURISTIC("WarnThirdPartyCookieHeuristic");

    private String value;

    private CookieWarningReason(String value) {
        this.value = value;
    }

    public static CookieWarningReason fromString(String s) {
        return Arrays.stream(CookieWarningReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within CookieWarningReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieWarningReason fromJson(JsonInput input) {
        return CookieWarningReason.fromString(input.nextString());
    }
}

