/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.AbstractIOFileFilterTest;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractConditionalFileFilterTest
extends AbstractIOFileFilterTest {
    private static final String TEST_FILE_NAME_PREFIX = "TestFile";
    private static final String TEST_FILE_TYPE = ".tst";
    protected AbstractIOFileFilterTest.TesterTrueFileFilter[] trueFilters;
    protected AbstractIOFileFilterTest.TesterFalseFileFilter[] falseFilters;
    private File file;
    private File workingPath;

    protected abstract IOFileFilter buildFilterUsingAdd(List<IOFileFilter> var1);

    protected abstract IOFileFilter buildFilterUsingConstructor(List<IOFileFilter> var1);

    protected abstract ConditionalFileFilter getConditionalFileFilter();

    protected abstract String getDefaultWorkingPath();

    protected abstract List<boolean[]> getFalseResults();

    protected abstract List<Boolean> getFilenameResults();

    protected abstract List<Boolean> getFileResults();

    protected abstract List<List<IOFileFilter>> getTestFilters();

    protected abstract List<boolean[]> getTrueResults();

    protected abstract String getWorkingPathNamePropertyKey();

    @BeforeEach
    public void setUp() {
        this.workingPath = AbstractConditionalFileFilterTest.determineWorkingDirectoryPath(this.getWorkingPathNamePropertyKey(), this.getDefaultWorkingPath());
        this.file = new File(this.workingPath, "TestFile1.tst");
        this.trueFilters = new AbstractIOFileFilterTest.TesterTrueFileFilter[4];
        this.falseFilters = new AbstractIOFileFilterTest.TesterFalseFileFilter[4];
        this.trueFilters[1] = new AbstractIOFileFilterTest.TesterTrueFileFilter(this);
        this.trueFilters[2] = new AbstractIOFileFilterTest.TesterTrueFileFilter(this);
        this.trueFilters[3] = new AbstractIOFileFilterTest.TesterTrueFileFilter(this);
        this.falseFilters[1] = new AbstractIOFileFilterTest.TesterFalseFileFilter(this);
        this.falseFilters[2] = new AbstractIOFileFilterTest.TesterFalseFileFilter(this);
        this.falseFilters[3] = new AbstractIOFileFilterTest.TesterFalseFileFilter(this);
    }

    @Test
    public void testAdd() {
        ArrayList<AbstractIOFileFilterTest.TesterTrueFileFilter> filters = new ArrayList<AbstractIOFileFilterTest.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        for (int i = 0; i < filters.size(); ++i) {
            Assertions.assertEquals((int)i, (int)fileFilter.getFileFilters().size(), (String)"file filters count: ");
            fileFilter.addFileFilter((IOFileFilter)filters.get(i));
            Assertions.assertEquals((int)(i + 1), (int)fileFilter.getFileFilters().size(), (String)"file filters count: ");
        }
        fileFilter.getFileFilters().forEach(filter -> Assertions.assertTrue((boolean)filters.contains(filter), (String)"found file filter"));
        Assertions.assertEquals((int)filters.size(), (int)fileFilter.getFileFilters().size(), (String)"file filters count");
    }

    @Test
    public void testFilterBuiltUsingAdd() {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean fileNameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingAdd(filters);
            AbstractConditionalFileFilterTest.resetTrueFilters(this.trueFilters);
            AbstractConditionalFileFilterTest.resetFalseFilters(this.falseFilters);
            AbstractConditionalFileFilterTest.assertFileFiltering(i, filter, this.file, fileResults);
            AbstractConditionalFileFilterTest.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            AbstractConditionalFileFilterTest.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            AbstractConditionalFileFilterTest.resetTrueFilters(this.trueFilters);
            AbstractConditionalFileFilterTest.resetFalseFilters(this.falseFilters);
            AbstractConditionalFileFilterTest.assertFilenameFiltering(i, filter, this.file, fileNameResults);
            AbstractConditionalFileFilterTest.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            AbstractConditionalFileFilterTest.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    @Test
    public void testFilterBuiltUsingConstructor() {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean fileNameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingConstructor(filters);
            AbstractConditionalFileFilterTest.resetTrueFilters(this.trueFilters);
            AbstractConditionalFileFilterTest.resetFalseFilters(this.falseFilters);
            AbstractConditionalFileFilterTest.assertFileFiltering(i, filter, this.file, fileResults);
            AbstractConditionalFileFilterTest.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            AbstractConditionalFileFilterTest.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            AbstractConditionalFileFilterTest.resetTrueFilters(this.trueFilters);
            AbstractConditionalFileFilterTest.resetFalseFilters(this.falseFilters);
            AbstractConditionalFileFilterTest.assertFilenameFiltering(i, filter, this.file, fileNameResults);
            AbstractConditionalFileFilterTest.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            AbstractConditionalFileFilterTest.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    @Test
    public void testNoFilters() {
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        File file = new File(this.workingPath, "TestFile1.tst");
        AbstractConditionalFileFilterTest.assertFileFiltering(1, (IOFileFilter)fileFilter, file, false);
        AbstractConditionalFileFilterTest.assertFilenameFiltering(1, (IOFileFilter)fileFilter, file, false);
    }

    @Test
    public void testRemove() {
        ArrayList<AbstractIOFileFilterTest.TesterTrueFileFilter> filters = new ArrayList<AbstractIOFileFilterTest.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.add(new AbstractIOFileFilterTest.TesterTrueFileFilter(this));
        filters.forEach(filter -> {
            fileFilter.removeFileFilter((IOFileFilter)filter);
            Assertions.assertFalse((boolean)fileFilter.getFileFilters().contains(filter), (String)"file filter removed");
        });
        Assertions.assertEquals((int)0, (int)fileFilter.getFileFilters().size(), (String)"file filters count");
    }
}

