/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.ClosedOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClosedOutputStreamTest {
    @Test
    public void testFlush() throws IOException {
        try (ClosedOutputStream cos = new ClosedOutputStream();){
            Assertions.assertThrows(IOException.class, () -> ((ClosedOutputStream)cos).flush());
        }
    }

    @Test
    public void testSingleton() throws IOException {
        try (ClosedOutputStream cos = ClosedOutputStream.CLOSED_OUTPUT_STREAM;){
            Assertions.assertThrows(IOException.class, () -> ((ClosedOutputStream)cos).flush());
        }
        cos = ClosedOutputStream.INSTANCE;
        try {
            Assertions.assertThrows(IOException.class, () -> ((ClosedOutputStream)cos).flush());
        }
        finally {
            if (cos != null) {
                cos.close();
            }
        }
    }

    @Test
    public void testWrite() throws IOException {
        try (ClosedOutputStream cos = new ClosedOutputStream();){
            Assertions.assertThrows(IOException.class, () -> cos.write(120));
        }
    }

    @Test
    public void testWriteArray() throws IOException {
        try (ClosedOutputStream cos = new ClosedOutputStream();){
            Assertions.assertThrows(IOException.class, () -> cos.write(new byte[0]));
            Assertions.assertThrows(IOException.class, () -> cos.write(new byte[10]));
        }
    }

    @Test
    public void testWriteArrayIndex() throws IOException {
        try (ClosedOutputStream cos = new ClosedOutputStream();){
            Assertions.assertThrows(IOException.class, () -> cos.write(new byte[0], 0, 0));
            Assertions.assertThrows(IOException.class, () -> cos.write(new byte[10], 0, 1));
        }
    }
}

