/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.incremental;

import graphql.Internal;
import graphql.execution.incremental.IncrementalCall;
import graphql.execution.reactive.SingleSubscriberPublisher;
import graphql.incremental.DelayedIncrementalPartialResult;
import graphql.incremental.DelayedIncrementalPartialResultImpl;
import graphql.incremental.IncrementalPayload;
import graphql.util.InterThreadMemoizedSupplier;
import graphql.util.LockKit;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

@Internal
public class IncrementalCallState {
    private final AtomicBoolean incrementalCallsDetected = new AtomicBoolean(false);
    private final Deque<IncrementalCall<? extends IncrementalPayload>> incrementalCalls = new ConcurrentLinkedDeque<IncrementalCall<? extends IncrementalPayload>>();
    private final Supplier<SingleSubscriberPublisher<DelayedIncrementalPartialResult>> publisher = this.createPublisher();
    private final AtomicInteger pendingCalls = new AtomicInteger();
    private final LockKit.ReentrantLock publisherLock = new LockKit.ReentrantLock();

    private void drainIncrementalCalls() {
        IncrementalCall<? extends IncrementalPayload> incrementalCall = this.incrementalCalls.poll();
        while (incrementalCall != null) {
            incrementalCall.invoke().whenComplete((payload, exception) -> {
                int remainingCalls;
                if (exception != null) {
                    this.publisher.get().offerError((Throwable)exception);
                    return;
                }
                this.publisherLock.lock();
                try {
                    remainingCalls = this.pendingCalls.decrementAndGet();
                    DelayedIncrementalPartialResultImpl executionResult = DelayedIncrementalPartialResultImpl.newIncrementalExecutionResult().incrementalItems(Collections.singletonList(payload)).hasNext(remainingCalls != 0).build();
                    this.publisher.get().offer(executionResult);
                }
                finally {
                    this.publisherLock.unlock();
                }
                if (remainingCalls == 0) {
                    this.publisher.get().noMoreData();
                } else {
                    this.drainIncrementalCalls();
                }
            });
            incrementalCall = this.incrementalCalls.poll();
        }
    }

    public void enqueue(IncrementalCall<? extends IncrementalPayload> incrementalCall) {
        this.publisherLock.runLocked(() -> {
            this.incrementalCallsDetected.set(true);
            this.incrementalCalls.offer(incrementalCall);
            this.pendingCalls.incrementAndGet();
        });
    }

    public void enqueue(Collection<IncrementalCall<? extends IncrementalPayload>> calls) {
        calls.forEach(this::enqueue);
    }

    public boolean getIncrementalCallsDetected() {
        return this.incrementalCallsDetected.get();
    }

    private Supplier<SingleSubscriberPublisher<DelayedIncrementalPartialResult>> createPublisher() {
        return new InterThreadMemoizedSupplier<SingleSubscriberPublisher<DelayedIncrementalPartialResult>>(() -> new SingleSubscriberPublisher(this::drainIncrementalCalls));
    }

    public Publisher<DelayedIncrementalPartialResult> startDeferredCalls() {
        return this.publisher.get();
    }
}

