/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.errors.StrictModeWiringException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;

@PublicApi
public class TypeRuntimeWiring {
    private static final AtomicBoolean DEFAULT_STRICT_MODE = new AtomicBoolean(false);
    private final String typeName;
    private final DataFetcher defaultDataFetcher;
    private final Map<String, DataFetcher> fieldDataFetchers;
    private final TypeResolver typeResolver;
    private final EnumValuesProvider enumValuesProvider;

    public static void setStrictModeJvmWide(boolean strictMode) {
        DEFAULT_STRICT_MODE.set(strictMode);
    }

    public static boolean getStrictModeJvmWide() {
        return DEFAULT_STRICT_MODE.get();
    }

    private TypeRuntimeWiring(String typeName, DataFetcher defaultDataFetcher, Map<String, DataFetcher> fieldDataFetchers, TypeResolver typeResolver, EnumValuesProvider enumValuesProvider) {
        this.typeName = typeName;
        this.defaultDataFetcher = defaultDataFetcher;
        this.fieldDataFetchers = fieldDataFetchers;
        this.typeResolver = typeResolver;
        this.enumValuesProvider = enumValuesProvider;
    }

    public static Builder newTypeWiring(String typeName) {
        Assert.assertNotNull(typeName, () -> "You must provide a type name");
        return new Builder().typeName(typeName);
    }

    public static TypeRuntimeWiring newTypeWiring(String typeName, UnaryOperator<Builder> builderFunction) {
        return ((Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName))).build();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Map<String, DataFetcher> getFieldDataFetchers() {
        return this.fieldDataFetchers;
    }

    public DataFetcher getDefaultDataFetcher() {
        return this.defaultDataFetcher;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public EnumValuesProvider getEnumValuesProvider() {
        return this.enumValuesProvider;
    }

    public static class Builder {
        private final Map<String, DataFetcher> fieldDataFetchers = new LinkedHashMap<String, DataFetcher>();
        private String typeName;
        private DataFetcher defaultDataFetcher;
        private TypeResolver typeResolver;
        private EnumValuesProvider enumValuesProvider;
        private boolean strictMode = DEFAULT_STRICT_MODE.get();

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder strictMode() {
            this.strictMode = true;
            return this;
        }

        public Builder dataFetcher(String fieldName, DataFetcher dataFetcher) {
            Assert.assertNotNull(dataFetcher, () -> "you must provide a data fetcher");
            Assert.assertNotNull(fieldName, () -> "you must tell us what field");
            if (this.strictMode) {
                this.assertFieldStrictly(fieldName);
            }
            this.fieldDataFetchers.put(fieldName, dataFetcher);
            return this;
        }

        public Builder dataFetchers(Map<String, DataFetcher> dataFetchersMap) {
            Assert.assertNotNull(dataFetchersMap, () -> "you must provide a data fetchers map");
            if (this.strictMode) {
                dataFetchersMap.forEach((fieldName, df) -> this.assertFieldStrictly((String)fieldName));
            }
            this.fieldDataFetchers.putAll(dataFetchersMap);
            return this;
        }

        private void assertFieldStrictly(String fieldName) {
            if (this.fieldDataFetchers.containsKey(fieldName)) {
                throw new StrictModeWiringException(String.format("The field %s already has a data fetcher defined", fieldName));
            }
        }

        public Builder defaultDataFetcher(DataFetcher dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            if (this.strictMode && this.defaultDataFetcher != null) {
                throw new StrictModeWiringException(String.format("The type %s has already has a default data fetcher defined", this.typeName));
            }
            this.defaultDataFetcher = dataFetcher;
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            Assert.assertNotNull(typeResolver, () -> "you must provide a type resolver");
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder enumValues(EnumValuesProvider enumValuesProvider) {
            Assert.assertNotNull(enumValuesProvider, () -> "you must provide an enum values provider");
            this.enumValuesProvider = enumValuesProvider;
            return this;
        }

        public TypeRuntimeWiring build() {
            Assert.assertNotNull(this.typeName, () -> "you must provide a type name");
            return new TypeRuntimeWiring(this.typeName, this.defaultDataFetcher, this.fieldDataFetchers, this.typeResolver, this.enumValuesProvider);
        }
    }
}

