/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.remote.http.HttpHeader;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;

public class Tags {
    private static final Map<Integer, Status> STATUS_CODE_TO_TRACING_STATUS = Stream.of(new AbstractMap.SimpleEntry<Integer, Status>(401, Status.UNAUTHENTICATED), new AbstractMap.SimpleEntry<Integer, Status>(404, Status.NOT_FOUND), new AbstractMap.SimpleEntry<Integer, Status>(408, Status.DEADLINE_EXCEEDED), new AbstractMap.SimpleEntry<Integer, Status>(429, Status.RESOURCE_EXHAUSTED), new AbstractMap.SimpleEntry<Integer, Status>(499, Status.CANCELLED), new AbstractMap.SimpleEntry<Integer, Status>(501, Status.UNIMPLEMENTED), new AbstractMap.SimpleEntry<Integer, Status>(503, Status.UNAVAILABLE), new AbstractMap.SimpleEntry<Integer, Status>(504, Status.DEADLINE_EXCEEDED)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    public static final BiConsumer<Span, Span.Kind> KIND = (span, kind) -> span.setAttribute(AttributeKey.SPAN_KIND.getKey(), kind.toString());
    public static final BiConsumer<Span, HttpRequest> HTTP_REQUEST = (span, req) -> {
        span.setAttribute(AttributeKey.HTTP_METHOD.getKey(), req.getMethod().toString());
        span.setAttribute(AttributeKey.HTTP_TARGET.getKey(), req.getUri());
    };
    public static final BiConsumer<Span, HttpResponse> HTTP_RESPONSE = (span, res) -> {
        int statusCode = res.getStatus();
        if (res.getTargetHost() != null) {
            span.setAttribute(AttributeKey.HTTP_TARGET_HOST.getKey(), res.getTargetHost());
        }
        span.setAttribute(AttributeKey.HTTP_STATUS_CODE.getKey(), statusCode);
        if (statusCode > 99 && statusCode < 400) {
            span.setStatus(Status.OK);
        } else if (statusCode > 399 && statusCode < 500) {
            span.setStatus(STATUS_CODE_TO_TRACING_STATUS.getOrDefault(statusCode, Status.INVALID_ARGUMENT));
        } else if (statusCode > 499 && statusCode < 600) {
            span.setStatus(STATUS_CODE_TO_TRACING_STATUS.getOrDefault(statusCode, Status.INTERNAL));
        } else {
            span.setStatus(Status.UNKNOWN);
        }
    };
    public static final BiConsumer<AttributeMap, HttpRequest> HTTP_REQUEST_EVENT = (map, req) -> {
        Object httpVersion;
        Object httpScheme;
        String clientIpAddress;
        String contentLength;
        String host;
        map.put(AttributeKey.HTTP_METHOD.getKey(), req.getMethod().toString());
        map.put(AttributeKey.HTTP_TARGET.getKey(), req.getUri());
        String userAgent = req.getHeader(HttpHeader.UserAgent.getName());
        if (userAgent != null) {
            map.put(AttributeKey.HTTP_USER_AGENT.getKey(), userAgent);
        }
        if ((host = req.getHeader(HttpHeader.Host.getName())) != null) {
            map.put(AttributeKey.HTTP_HOST.getKey(), host);
        }
        if ((contentLength = req.getHeader(HttpHeader.ContentLength.getName())) != null) {
            map.put(AttributeKey.HTTP_REQUEST_CONTENT_LENGTH.getKey(), contentLength);
        }
        if ((clientIpAddress = req.getHeader(HttpHeader.XForwardedFor.getName())) != null) {
            map.put(AttributeKey.HTTP_CLIENT_IP.getKey(), clientIpAddress);
        }
        if ((httpScheme = req.getAttribute(AttributeKey.HTTP_SCHEME.getKey())) != null) {
            map.put(AttributeKey.HTTP_SCHEME.getKey(), (String)httpScheme);
        }
        if ((httpVersion = req.getAttribute(AttributeKey.HTTP_FLAVOR.getKey())) != null) {
            map.put(AttributeKey.HTTP_FLAVOR.getKey(), (long)((Integer)httpVersion).intValue());
        }
    };
    public static final BiConsumer<AttributeMap, HttpResponse> HTTP_RESPONSE_EVENT = (map, res) -> {
        int statusCode = res.getStatus();
        if (res.getTargetHost() != null) {
            map.put(AttributeKey.HTTP_TARGET_HOST.getKey(), res.getTargetHost());
        }
        map.put(AttributeKey.HTTP_STATUS_CODE.getKey(), (long)statusCode);
    };
    public static final BiConsumer<AttributeMap, Throwable> EXCEPTION = (map, t2) -> {
        StringWriter sw = new StringWriter();
        t2.printStackTrace(new PrintWriter(sw));
        map.put(AttributeKey.EXCEPTION_TYPE.getKey(), t2.getClass().getName());
        map.put(AttributeKey.EXCEPTION_STACKTRACE.getKey(), sw.toString());
    };

    private Tags() {
    }
}

