package org.openqa.selenium.devtools.v134.extensions.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Storage areas.
 */
public enum StorageArea {

    SESSION("session"), LOCAL("local"), SYNC("sync"), MANAGED("managed");

    private String value;

    StorageArea(String value) {
        this.value = value;
    }

    public static StorageArea fromString(String s) {
        return java.util.Arrays.stream(StorageArea.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within StorageArea "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static StorageArea fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
