package org.openqa.selenium.devtools.v134.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ScopeExtension {

    private final java.lang.String origin;

    private final java.lang.Boolean hasOriginWildcard;

    public ScopeExtension(java.lang.String origin, java.lang.Boolean hasOriginWildcard) {
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.hasOriginWildcard = java.util.Objects.requireNonNull(hasOriginWildcard, "hasOriginWildcard is required");
    }

    /**
     * Instead of using tuple, this field always returns the serialized string
     * for easy understanding and comparison.
     */
    public java.lang.String getOrigin() {
        return origin;
    }

    public java.lang.Boolean getHasOriginWildcard() {
        return hasOriginWildcard;
    }

    private static ScopeExtension fromJson(JsonInput input) {
        java.lang.String origin = null;
        java.lang.Boolean hasOriginWildcard = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "origin":
                    origin = input.nextString();
                    break;
                case "hasOriginWildcard":
                    hasOriginWildcard = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScopeExtension(origin, hasOriginWildcard);
    }
}
