package org.openqa.selenium.devtools.v135.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates the various states of Central.
 */
public enum CentralState {

    ABSENT("absent"), POWERED_OFF("powered-off"), POWERED_ON("powered-on");

    private String value;

    CentralState(String value) {
        this.value = value;
    }

    public static CentralState fromString(String s) {
        return java.util.Arrays.stream(CentralState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CentralState "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CentralState fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
