package org.openqa.selenium.devtools.v135.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The status of a Reporting API report.
 */
@org.openqa.selenium.Beta()
public enum ReportStatus {

    QUEUED("Queued"), PENDING("Pending"), MARKEDFORREMOVAL("MarkedForRemoval"), SUCCESS("Success");

    private String value;

    ReportStatus(String value) {
        this.value = value;
    }

    public static ReportStatus fromString(String s) {
        return java.util.Arrays.stream(ReportStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ReportStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ReportStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
