package org.openqa.selenium.devtools.v131.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS style representation.
 */
public class CSSStyle {

    private final java.util.Optional<org.openqa.selenium.devtools.v131.css.model.StyleSheetId> styleSheetId;

    private final java.util.List<org.openqa.selenium.devtools.v131.css.model.CSSProperty> cssProperties;

    private final java.util.List<org.openqa.selenium.devtools.v131.css.model.ShorthandEntry> shorthandEntries;

    private final java.util.Optional<java.lang.String> cssText;

    private final java.util.Optional<org.openqa.selenium.devtools.v131.css.model.SourceRange> range;

    public CSSStyle(java.util.Optional<org.openqa.selenium.devtools.v131.css.model.StyleSheetId> styleSheetId, java.util.List<org.openqa.selenium.devtools.v131.css.model.CSSProperty> cssProperties, java.util.List<org.openqa.selenium.devtools.v131.css.model.ShorthandEntry> shorthandEntries, java.util.Optional<java.lang.String> cssText, java.util.Optional<org.openqa.selenium.devtools.v131.css.model.SourceRange> range) {
        this.styleSheetId = styleSheetId;
        this.cssProperties = java.util.Objects.requireNonNull(cssProperties, "cssProperties is required");
        this.shorthandEntries = java.util.Objects.requireNonNull(shorthandEntries, "shorthandEntries is required");
        this.cssText = cssText;
        this.range = range;
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v131.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * CSS properties in the style.
     */
    public java.util.List<org.openqa.selenium.devtools.v131.css.model.CSSProperty> getCssProperties() {
        return cssProperties;
    }

    /**
     * Computed values for all shorthands found in the style.
     */
    public java.util.List<org.openqa.selenium.devtools.v131.css.model.ShorthandEntry> getShorthandEntries() {
        return shorthandEntries;
    }

    /**
     * Style declaration text (if available).
     */
    public java.util.Optional<java.lang.String> getCssText() {
        return cssText;
    }

    /**
     * Style declaration range in the enclosing stylesheet (if available).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v131.css.model.SourceRange> getRange() {
        return range;
    }

    private static CSSStyle fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v131.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v131.css.model.CSSProperty> cssProperties = null;
        java.util.List<org.openqa.selenium.devtools.v131.css.model.ShorthandEntry> shorthandEntries = null;
        java.util.Optional<java.lang.String> cssText = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v131.css.model.SourceRange> range = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v131.css.model.StyleSheetId.class));
                    break;
                case "cssProperties":
                    cssProperties = input.readArray(org.openqa.selenium.devtools.v131.css.model.CSSProperty.class);
                    break;
                case "shorthandEntries":
                    shorthandEntries = input.readArray(org.openqa.selenium.devtools.v131.css.model.ShorthandEntry.class);
                    break;
                case "cssText":
                    cssText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "range":
                    range = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v131.css.model.SourceRange.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSStyle(styleSheetId, cssProperties, shorthandEntries, cssText, range);
    }
}
