package org.openqa.selenium.devtools.v132.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when handling requests for resources within a .wbn file.
 * Note: this will only be fired for resources that are requested by the webpage.
 */
@org.openqa.selenium.Beta()
public class SubresourceWebBundleInnerResponseParsed {

    private final org.openqa.selenium.devtools.v132.network.model.RequestId innerRequestId;

    private final java.lang.String innerRequestURL;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.network.model.RequestId> bundleRequestId;

    public SubresourceWebBundleInnerResponseParsed(org.openqa.selenium.devtools.v132.network.model.RequestId innerRequestId, java.lang.String innerRequestURL, java.util.Optional<org.openqa.selenium.devtools.v132.network.model.RequestId> bundleRequestId) {
        this.innerRequestId = java.util.Objects.requireNonNull(innerRequestId, "innerRequestId is required");
        this.innerRequestURL = java.util.Objects.requireNonNull(innerRequestURL, "innerRequestURL is required");
        this.bundleRequestId = bundleRequestId;
    }

    /**
     * Request identifier of the subresource request
     */
    public org.openqa.selenium.devtools.v132.network.model.RequestId getInnerRequestId() {
        return innerRequestId;
    }

    /**
     * URL of the subresource resource.
     */
    public java.lang.String getInnerRequestURL() {
        return innerRequestURL;
    }

    /**
     * Bundle request identifier. Used to match this information to another event.
     * This made be absent in case when the instrumentation was enabled only
     * after webbundle was parsed.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.network.model.RequestId> getBundleRequestId() {
        return bundleRequestId;
    }

    private static SubresourceWebBundleInnerResponseParsed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.network.model.RequestId innerRequestId = null;
        java.lang.String innerRequestURL = null;
        java.util.Optional<org.openqa.selenium.devtools.v132.network.model.RequestId> bundleRequestId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "innerRequestId":
                    innerRequestId = input.read(org.openqa.selenium.devtools.v132.network.model.RequestId.class);
                    break;
                case "innerRequestURL":
                    innerRequestURL = input.nextString();
                    break;
                case "bundleRequestId":
                    bundleRequestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.network.model.RequestId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SubresourceWebBundleInnerResponseParsed(innerRequestId, innerRequestURL, bundleRequestId);
    }
}
