package org.openqa.selenium.devtools.v132.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A single Related Website Set object.
 */
@org.openqa.selenium.Beta()
public class RelatedWebsiteSet {

    private final java.util.List<java.lang.String> primarySites;

    private final java.util.List<java.lang.String> associatedSites;

    private final java.util.List<java.lang.String> serviceSites;

    public RelatedWebsiteSet(java.util.List<java.lang.String> primarySites, java.util.List<java.lang.String> associatedSites, java.util.List<java.lang.String> serviceSites) {
        this.primarySites = java.util.Objects.requireNonNull(primarySites, "primarySites is required");
        this.associatedSites = java.util.Objects.requireNonNull(associatedSites, "associatedSites is required");
        this.serviceSites = java.util.Objects.requireNonNull(serviceSites, "serviceSites is required");
    }

    /**
     * The primary site of this set, along with the ccTLDs if there is any.
     */
    public java.util.List<java.lang.String> getPrimarySites() {
        return primarySites;
    }

    /**
     * The associated sites of this set, along with the ccTLDs if there is any.
     */
    public java.util.List<java.lang.String> getAssociatedSites() {
        return associatedSites;
    }

    /**
     * The service sites of this set, along with the ccTLDs if there is any.
     */
    public java.util.List<java.lang.String> getServiceSites() {
        return serviceSites;
    }

    private static RelatedWebsiteSet fromJson(JsonInput input) {
        java.util.List<java.lang.String> primarySites = null;
        java.util.List<java.lang.String> associatedSites = null;
        java.util.List<java.lang.String> serviceSites = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "primarySites":
                    primarySites = input.readArray(java.lang.String.class);
                    break;
                case "associatedSites":
                    associatedSites = input.readArray(java.lang.String.class);
                    break;
                case "serviceSites":
                    serviceSites = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RelatedWebsiteSet(primarySites, associatedSites, serviceSites);
    }
}
