/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.png;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class PNGEncoder
extends VideoEncoder {
    private static final long PNGSIG = -8552249625308161526L;
    private static final int TAG_IHDR = 1229472850;
    private static final int TAG_IDAT = 1229209940;
    private static final int TAG_IEND = 1229278788;
    private static final int PNG_COLOR_MASK_COLOR = 2;

    private static int crc32(ByteBuffer from, ByteBuffer to) {
        from.limit(to.position());
        CRC32 crc32 = new CRC32();
        crc32.update(NIOUtils.toArray(from));
        return (int)crc32.getValue();
    }

    @Override
    public VideoEncoder.EncodedFrame encodeFrame(Picture pic, ByteBuffer out) {
        ByteBuffer _out = out.duplicate();
        _out.putLong(-8552249625308161526L);
        IHDR ihdr = new IHDR();
        ihdr.width = pic.getCroppedWidth();
        ihdr.height = pic.getCroppedHeight();
        ihdr.bitDepth = (byte)8;
        ihdr.colorType = (byte)2;
        _out.putInt(13);
        ByteBuffer crcFrom = _out.duplicate();
        _out.putInt(1229472850);
        ihdr.write(_out);
        _out.putInt(PNGEncoder.crc32(crcFrom, _out));
        Deflater deflater = new Deflater();
        byte[] rowData = new byte[pic.getCroppedWidth() * 3 + 1];
        byte[] pix = pic.getPlaneData(0);
        byte[] buffer = new byte[32768];
        int ptr = 0;
        int len = buffer.length;
        int lineStep = (pic.getWidth() - pic.getCroppedWidth()) * 3;
        int bptr = 0;
        for (int row = 0; row < pic.getCroppedHeight() + 1; ++row) {
            int count;
            while ((count = deflater.deflate(buffer, ptr, len)) > 0) {
                ptr += count;
                if ((len -= count) != 0) continue;
                _out.putInt(ptr);
                crcFrom = _out.duplicate();
                _out.putInt(1229209940);
                _out.put(buffer, 0, ptr);
                _out.putInt(PNGEncoder.crc32(crcFrom, _out));
                ptr = 0;
                len = buffer.length;
            }
            if (row >= pic.getCroppedHeight()) break;
            rowData[0] = 0;
            int i = 1;
            while (i <= pic.getCroppedWidth() * 3) {
                rowData[i] = (byte)(pix[bptr] + 128);
                rowData[i + 1] = (byte)(pix[bptr + 1] + 128);
                rowData[i + 2] = (byte)(pix[bptr + 2] + 128);
                i += 3;
                bptr += 3;
            }
            bptr += lineStep;
            deflater.setInput(rowData);
            if (row < pic.getCroppedHeight() - 1) continue;
            deflater.finish();
        }
        if (ptr > 0) {
            _out.putInt(ptr);
            crcFrom = _out.duplicate();
            _out.putInt(1229209940);
            _out.put(buffer, 0, ptr);
            _out.putInt(PNGEncoder.crc32(crcFrom, _out));
        }
        _out.putInt(0);
        _out.putInt(1229278788);
        _out.putInt(-1371381630);
        _out.flip();
        return new VideoEncoder.EncodedFrame(_out, true);
    }

    @Override
    public ColorSpace[] getSupportedColorSpaces() {
        return new ColorSpace[]{ColorSpace.RGB};
    }

    @Override
    public int estimateBufferSize(Picture frame) {
        return frame.getCroppedWidth() * frame.getCroppedHeight() * 4;
    }

    private static class IHDR {
        private int width;
        private int height;
        private byte bitDepth;
        private byte colorType;
        private byte compressionType;
        private byte filterType;
        private byte interlaceType;

        private IHDR() {
        }

        public void write(ByteBuffer data) {
            data.putInt(this.width);
            data.putInt(this.height);
            data.put(this.bitDepth);
            data.put(this.colorType);
            data.put(this.compressionType);
            data.put(this.filterType);
            data.put(this.interlaceType);
        }
    }
}

