/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.transcode;

import java.util.ArrayList;
import java.util.List;
import org.jcodec.api.transcode.PixelStore;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class PixelStoreImpl
implements PixelStore {
    private List<Picture> buffers = new ArrayList<Picture>();

    @Override
    public PixelStore.LoanerPicture getPicture(int width, int height, ColorSpace color) {
        for (Picture picture : this.buffers) {
            if (picture.getWidth() != width || picture.getHeight() != height || picture.getColor() != color) continue;
            this.buffers.remove(picture);
            return new PixelStore.LoanerPicture(picture, 1);
        }
        return new PixelStore.LoanerPicture(Picture.create(width, height, color), 1);
    }

    @Override
    public void putBack(PixelStore.LoanerPicture frame) {
        frame.decRefCnt();
        if (frame.unused()) {
            Picture pixels = frame.getPicture();
            pixels.setCrop(null);
            this.buffers.add(pixels);
        }
    }

    @Override
    public void retake(PixelStore.LoanerPicture frame) {
        frame.incRefCnt();
    }
}

