/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.XmlStreamWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

public class XmlStreamWriterTest {
    private static final String TEXT_LATIN1 = "eacute: \u00e9";
    private static final String TEXT_LATIN7 = "alpha: \u03b1";
    private static final String TEXT_LATIN15 = "euro: \u20ac";
    private static final String TEXT_EUC_JP = "hiragana A: \u3042";
    private static final String TEXT_UNICODE = "eacute: \u00e9, alpha: \u03b1, euro: \u20ac, hiragana A: \u3042";

    private static void checkXmlContent(String xml, String encodingName, String defaultEncodingName) throws IOException {
        XmlStreamWriter writerCheck;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (XmlStreamWriter writer = ((XmlStreamWriter.Builder)((XmlStreamWriter.Builder)XmlStreamWriter.builder().setOutputStream((OutputStream)out)).setCharset(defaultEncodingName)).get();){
            writerCheck = writer;
            writer.write(xml);
        }
        byte[] xmlContent = out.toByteArray();
        Charset charset = Charset.forName(encodingName);
        Charset writerCharset = Charset.forName(writerCheck.getEncoding());
        Assertions.assertEquals((Object)charset, (Object)writerCharset);
        Assertions.assertTrue((boolean)writerCharset.contains(charset), (String)writerCharset.name());
        Assertions.assertArrayEquals((byte[])xml.getBytes(encodingName), (byte[])xmlContent);
    }

    private static void checkXmlWriter(String text, String encoding) throws IOException {
        XmlStreamWriterTest.checkXmlWriter(text, encoding, null);
    }

    private static void checkXmlWriter(String text, String encoding, String defaultEncoding) throws IOException {
        String xml = XmlStreamWriterTest.createXmlContent(text, encoding);
        String effectiveEncoding = encoding;
        if (effectiveEncoding == null) {
            effectiveEncoding = defaultEncoding == null ? StandardCharsets.UTF_8.name() : defaultEncoding;
        }
        XmlStreamWriterTest.checkXmlContent(xml, effectiveEncoding, defaultEncoding);
    }

    private static String createXmlContent(String text, String encoding) {
        String xmlDecl = "<?xml version=\"1.0\"?>";
        if (encoding != null) {
            xmlDecl = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        }
        return xmlDecl + "\n<text>" + text + "</text>";
    }

    @Test
    public void testDefaultEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, null);
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, StandardCharsets.UTF_8.name());
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, StandardCharsets.UTF_16.name());
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, StandardCharsets.UTF_16BE.name());
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, null, StandardCharsets.ISO_8859_1.name());
    }

    @Test
    public void testEBCDICEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter("simple text in EBCDIC", "CP1047");
    }

    @Test
    public void testEmpty() throws IOException {
        XmlStreamWriter writer;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            writer = new XmlStreamWriter((OutputStream)out);
            try {
                writer.flush();
                writer.write("");
                writer.flush();
                writer.write(".");
                writer.flush();
            }
            finally {
                writer.close();
            }
        }
        out = new ByteArrayOutputStream();
        try {
            writer = ((XmlStreamWriter.Builder)XmlStreamWriter.builder().setOutputStream((OutputStream)out)).get();
            try {
                writer.flush();
                writer.write("");
                writer.flush();
                writer.write(".");
                writer.flush();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            out.close();
        }
    }

    @Test
    public void testEUC_JPEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_EUC_JP, "EUC-JP");
    }

    @Test
    public void testLatin15Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN15, "ISO-8859-15");
    }

    @Test
    public void testLatin1Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN1, StandardCharsets.ISO_8859_1.name());
    }

    @Test
    public void testLatin7Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN7, "ISO-8859-7");
    }

    @Test
    @DefaultLocale(language="tr")
    public void testLowerCaseEncodingWithTurkishLocale_IO_557() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, "utf-8");
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN1, "iso-8859-1");
        XmlStreamWriterTest.checkXmlWriter(TEXT_LATIN7, "iso-8859-7");
    }

    @Test
    public void testNoXmlHeader() throws IOException {
        XmlStreamWriterTest.checkXmlContent("<text>text with no XML header</text>", StandardCharsets.UTF_8.name(), null);
    }

    @Test
    public void testUTF16BEEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, StandardCharsets.UTF_16BE.name());
    }

    @Test
    public void testUTF16Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, StandardCharsets.UTF_16.name());
    }

    @Test
    public void testUTF16LEEncoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, StandardCharsets.UTF_16LE.name());
    }

    @Test
    public void testUTF8Encoding() throws IOException {
        XmlStreamWriterTest.checkXmlWriter(TEXT_UNICODE, StandardCharsets.UTF_8.name());
    }
}

