/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.browser.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum PermissionSetting {
    GRANTED("granted"),
    DENIED("denied"),
    PROMPT("prompt");

    private String value;

    private PermissionSetting(String value) {
        this.value = value;
    }

    public static PermissionSetting fromString(String s) {
        return Arrays.stream(PermissionSetting.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PermissionSetting "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PermissionSetting fromJson(JsonInput input) {
        return PermissionSetting.fromString(input.nextString());
    }
}

