/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.bidi.network.SetCookieHeader;

public class ContinueResponseParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public ContinueResponseParameters(String request) {
        this.map.put("request", request);
    }

    public ContinueResponseParameters cookies(List<SetCookieHeader> cookieHeaders) {
        List cookies = cookieHeaders.stream().map(SetCookieHeader::toMap).collect(Collectors.toList());
        this.map.put("cookies", cookies);
        return this;
    }

    public ContinueResponseParameters credentials(UsernameAndPassword credentials) {
        this.map.put("credentials", Map.of("type", "password", "username", credentials.username(), "password", credentials.password()));
        return this;
    }

    public ContinueResponseParameters headers(List<Header> headers) {
        List headerList = headers.stream().map(Header::toMap).collect(Collectors.toList());
        this.map.put("headers", headerList);
        return this;
    }

    public ContinueResponseParameters reasonPhrase(String reasonPhrase) {
        this.map.put("reasonPhrase", reasonPhrase);
        return this;
    }

    public ContinueResponseParameters statusCode(int statusCode) {
        this.map.put("statusCode", statusCode);
        return this;
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

