/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class ExceptionDetails {
    private final long columnNumber;
    private final RemoteValue exception;
    private final long lineNumber;
    private final StackTrace stacktrace;
    private final String text;

    public ExceptionDetails(long columnNumber, RemoteValue exception, long lineNumber, StackTrace stacktrace, String text) {
        this.columnNumber = columnNumber;
        this.exception = exception;
        this.lineNumber = lineNumber;
        this.stacktrace = stacktrace;
        this.text = text;
    }

    public static ExceptionDetails fromJson(JsonInput input) {
        long columnNumber = 0L;
        RemoteValue exception = null;
        long lineNumber = 0L;
        StackTrace stackTrace = null;
        String text = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "columnNumber": {
                    columnNumber = (Long)input.read((Type)((Object)Long.class));
                    continue block14;
                }
                case "exception": {
                    exception = (RemoteValue)input.read((Type)((Object)RemoteValue.class));
                    continue block14;
                }
                case "lineNumber": {
                    lineNumber = (Long)input.read((Type)((Object)Long.class));
                    continue block14;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read((Type)((Object)StackTrace.class));
                    continue block14;
                }
                case "text": {
                    text = (String)input.read((Type)((Object)String.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExceptionDetails(columnNumber, exception, lineNumber, stackTrace, text);
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public RemoteValue getException() {
        return this.exception;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public StackTrace getStacktrace() {
        return this.stacktrace;
    }

    public String getText() {
        return this.text;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("columnNumber", this.columnNumber);
        toReturn.put("exception", this.exception);
        toReturn.put("lineNumber", this.lineNumber);
        toReturn.put("stacktrace", this.stacktrace);
        toReturn.put("text", this.text);
        return Collections.unmodifiableMap(toReturn);
    }
}

