/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.io.UncheckedIOException;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class StatusHandler
implements HttpHandler {
    private final Node node;

    StatusHandler(Node node) {
        this.node = Require.nonNull("Node", node);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        NodeStatus status = this.node.getStatus();
        ImmutableMap<String, ImmutableMap<String, NodeStatus>> report = ImmutableMap.of("value", ImmutableMap.of("ready", status.hasCapacity(), "message", status.hasCapacity() ? "Ready" : "No free slots available", "registered", this.node.isRegistered(), "node", status));
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(report));
    }
}

