/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.webauthn.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v135.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.v135.webauthn.model.Credential;
import org.openqa.selenium.json.JsonInput;

public class CredentialAdded {
    private final AuthenticatorId authenticatorId;
    private final Credential credential;

    public CredentialAdded(AuthenticatorId authenticatorId, Credential credential) {
        this.authenticatorId = Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        this.credential = Objects.requireNonNull(credential, "credential is required");
    }

    public AuthenticatorId getAuthenticatorId() {
        return this.authenticatorId;
    }

    public Credential getCredential() {
        return this.credential;
    }

    private static CredentialAdded fromJson(JsonInput input) {
        AuthenticatorId authenticatorId = null;
        Credential credential = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "authenticatorId": {
                    authenticatorId = (AuthenticatorId)input.read(AuthenticatorId.class);
                    continue block8;
                }
                case "credential": {
                    credential = (Credential)input.read(Credential.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CredentialAdded(authenticatorId, credential);
    }
}

