/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.parameters;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.schema.GraphQLSchema;
import java.util.Map;

@PublicApi
public class InstrumentationExecutionParameters {
    private final ExecutionInput executionInput;
    private final String query;
    private final String operation;
    private final Object context;
    private final GraphQLContext graphQLContext;
    private final Map<String, Object> variables;
    private final GraphQLSchema schema;

    public InstrumentationExecutionParameters(ExecutionInput executionInput, GraphQLSchema schema) {
        this.executionInput = executionInput;
        this.query = executionInput.getQuery();
        this.operation = executionInput.getOperationName();
        this.context = executionInput.getContext();
        this.graphQLContext = executionInput.getGraphQLContext();
        this.variables = executionInput.getVariables() != null ? executionInput.getVariables() : ImmutableKit.emptyMap();
        this.schema = schema;
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperation() {
        return this.operation;
    }

    @Deprecated(since="2021-07-05")
    public <T> T getContext() {
        return (T)this.context;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }
}

