/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilenameUtilsWildcardTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private void assertMatch(String text, String wildcard, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)FilenameUtils.wildcardMatch(text, wildcard), (String)(text + " " + wildcard));
    }

    @Test
    public void test_IO_246() {
        this.assertMatch("aaa", "aa*?", true);
        this.assertMatch("", "?*", false);
        this.assertMatch("a", "a?*", false);
        this.assertMatch("aa", "aa?*", false);
        this.assertMatch("a", "?*", true);
        this.assertMatch("aa", "?*", true);
        this.assertMatch("aaa", "?*", true);
        this.assertMatch("", "?", false);
        this.assertMatch("a", "a?", false);
        this.assertMatch("aa", "aa?", false);
        this.assertMatch("aab", "aa?", true);
        this.assertMatch("aaa", "*a", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = Locale.getAvailableLocales();
        String[][] data = new String[][]{{"I", "i"}, {"i", "I"}, {"i", "\u0130"}, {"i", "\u0131"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}, {"\u03c2", "\u03c3"}};
        try {
            for (int i = 0; i < data.length; ++i) {
                for (Locale locale : locales) {
                    Locale.setDefault(locale);
                    Assertions.assertTrue((boolean)data[i][0].equalsIgnoreCase(data[i][1]), (String)("Test data corrupt: " + i));
                    boolean match = FilenameUtils.wildcardMatch(data[i][0], data[i][1], IOCase.INSENSITIVE);
                    Assertions.assertTrue((boolean)match, (String)(Locale.getDefault().toString() + ": " + i));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    @Test
    public void testMatch() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch(null, "Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("Foo", null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("", "*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("", "?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Fo?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo Bar and Catflap", "Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("New Bookmarks", "N?w ?o?k??r?s"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("Foo", "Bar"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo Bar Foo", "F*o Bar*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Adobe Acrobat Installer", "Ad*er"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("BarFoo", "*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Foo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("FooBar", "Foo*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOO", "*Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("BARFOO", "*Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOO", "Foo*"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOOBAR", "Foo*"));
    }

    @Test
    public void testMatch2() {
        this.assertMatch("log.txt", "log.txt", true);
        this.assertMatch("log.txt1", "log.txt", false);
        this.assertMatch("log.txt", "log.txt*", true);
        this.assertMatch("log.txt", "log.txt*1", false);
        this.assertMatch("log.txt", "*log.txt*", true);
        this.assertMatch("log.txt", "*.txt", true);
        this.assertMatch("txt.log", "*.txt", false);
        this.assertMatch("config.ini", "*.ini", true);
        this.assertMatch("config.txt.bak", "con*.txt", false);
        this.assertMatch("log.txt9", "*.txt?", true);
        this.assertMatch("log.txt", "*.txt?", false);
        this.assertMatch("progtestcase.java~5~", "*test*.java~*~", true);
        this.assertMatch("progtestcase.java;5~", "*test*.java~*~", false);
        this.assertMatch("progtestcase.java~5", "*test*.java~*~", false);
        this.assertMatch("log.txt", "log.*", true);
        this.assertMatch("log.txt", "log?*", true);
        this.assertMatch("log.txt12", "log.txt??", true);
        this.assertMatch("log.log", "log**log", true);
        this.assertMatch("log.log", "log**", true);
        this.assertMatch("log.log", "log.**", true);
        this.assertMatch("log.log", "**.log", true);
        this.assertMatch("log.log", "**log", true);
        this.assertMatch("log.log", "log*log", true);
        this.assertMatch("log.log", "log*", true);
        this.assertMatch("log.log", "log.*", true);
        this.assertMatch("log.log", "*.log", true);
        this.assertMatch("log.log", "*log", true);
        this.assertMatch("log.log", "*log?", false);
        this.assertMatch("log.log", "*log?*", true);
        this.assertMatch("log.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc.d", "*log?abc?d", true);
    }

    @Test
    public void testMatchCaseSpecified() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch(null, "Foo", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("Foo", null, IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null, IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Foo", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("", "", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Fo*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Fo?", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo Bar and Catflap", "Fo*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("New Bookmarks", "N?w ?o?k??r?s", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("Foo", "Bar", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo Bar Foo", "F*o Bar*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Adobe Acrobat Installer", "Ad*er", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "*Foo", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Foo*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "*Foo", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("BarFoo", "*Foo", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("Foo", "Foo*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("FooBar", "Foo*", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOO", "*Foo", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("BARFOO", "*Foo", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOO", "Foo*", IOCase.SENSITIVE));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatch("FOOBAR", "Foo*", IOCase.SENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("FOO", "*Foo", IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("BARFOO", "*Foo", IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("FOO", "Foo*", IOCase.INSENSITIVE));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatch("FOOBAR", "Foo*", IOCase.INSENSITIVE));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch("FOO", "*Foo", IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch("BARFOO", "*Foo", IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch("FOO", "Foo*", IOCase.SYSTEM));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch("FOOBAR", "Foo*", IOCase.SYSTEM));
    }

    @Test
    public void testMatchOnSystem() {
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem(null, "Foo"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem(null, null));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("", ""));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "Fo?"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo Bar and Catflap", "Fo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("New Bookmarks", "N?w ?o?k??r?s"));
        Assertions.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "Bar"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo Bar Foo", "F*o Bar*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Adobe Acrobat Installer", "Ad*er"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("BarFoo", "*Foo"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("Foo", "Foo*"));
        Assertions.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem("FooBar", "Foo*"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem("FOO", "*Foo"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem("BARFOO", "*Foo"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem("FOO", "Foo*"));
        Assertions.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem("FOOBAR", "Foo*"));
    }

    @Test
    public void testSplitOnTokens() {
        Assertions.assertArrayEquals((Object[])new String[]{"Ad", "*", "er"}, (Object[])FilenameUtils.splitOnTokens("Ad*er"));
        Assertions.assertArrayEquals((Object[])new String[]{"Ad", "?", "er"}, (Object[])FilenameUtils.splitOnTokens("Ad?er"));
        Assertions.assertArrayEquals((Object[])new String[]{"Test", "*", "?", "One"}, (Object[])FilenameUtils.splitOnTokens("Test*?One"));
        Assertions.assertArrayEquals((Object[])new String[]{"Test", "?", "*", "One"}, (Object[])FilenameUtils.splitOnTokens("Test?*One"));
        Assertions.assertArrayEquals((Object[])new String[]{"*"}, (Object[])FilenameUtils.splitOnTokens("****"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens("*??*"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens("*?**?*"));
        Assertions.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens("*?***?*"));
        Assertions.assertArrayEquals((Object[])new String[]{"h", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens("h??*"));
        Assertions.assertArrayEquals((Object[])new String[]{""}, (Object[])FilenameUtils.splitOnTokens(""));
    }
}

