/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DirectoryFileFilterTest {
    @Test
    public void testJavadocExampleUsingIo() {
        File dir = FileUtils.current();
        String[] files = dir.list(DirectoryFileFilter.INSTANCE);
        Assertions.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJavadocExampleUsingNio() throws IOException {
        Path dir = Paths.get("", new String[0]);
        AccumulatorPathVisitor visitor = AccumulatorPathVisitor.withLongCounters(DirectoryFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
        Files.walkFileTree(dir, Collections.emptySet(), 1, visitor);
        visitor.getPathCounters().reset();
        Files.walkFileTree(dir, visitor);
        Assertions.assertEquals((long)0L, (long)visitor.getPathCounters().getFileCounter().get());
        Assertions.assertTrue((visitor.getPathCounters().getDirectoryCounter().get() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)visitor.getPathCounters().getByteCounter().get());
        Assertions.assertFalse((boolean)visitor.getDirList().isEmpty());
        Assertions.assertFalse((boolean)visitor.getFileList().isEmpty());
        Assertions.assertNotEquals((Object)Counters.noopPathCounters(), (Object)visitor.getPathCounters());
        visitor.getPathCounters().reset();
        CounterAssertions.assertZeroCounters(visitor.getPathCounters());
    }
}

