/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOBiFunctionTest {
    private boolean not(boolean value) throws IOException {
        return !value;
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        IOBiFunction<Path, LinkOption[], Boolean> isDirectory = Files::isDirectory;
        IOFunction<Boolean, Boolean> not = this::not;
        Assertions.assertTrue((boolean)isDirectory.apply(PathUtils.current(), PathUtils.EMPTY_LINK_OPTION_ARRAY));
        IOBiFunction<Path, LinkOption[], Boolean> andThen = isDirectory.andThen(not);
        Assertions.assertFalse((boolean)andThen.apply(PathUtils.current(), PathUtils.EMPTY_LINK_OPTION_ARRAY));
    }

    @Test
    public void testApply() throws IOException {
        IOBiFunction<Path, LinkOption[], Boolean> isDirectory = Files::isDirectory;
        Assertions.assertTrue((boolean)isDirectory.apply(PathUtils.current(), PathUtils.EMPTY_LINK_OPTION_ARRAY));
    }

    @Test
    public void testApplyThrowsException() {
        IOBiFunction<Path, LinkOption[], Boolean> isDirectory = (t2, u) -> {
            throw new IOException("Boom!");
        };
        Assertions.assertThrows(IOException.class, () -> isDirectory.apply(PathUtils.current(), PathUtils.EMPTY_LINK_OPTION_ARRAY));
    }

    @Test
    public void testAsBiFunction() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("1", 0L);
        IOBiFunction<String, Long, Long> f = (t2, u) -> Files.size(PathUtils.current());
        map.computeIfPresent("1", f.asBiFunction());
        Assertions.assertNotEquals((long)0L, (Long)((Long)map.get("1")));
    }
}

