/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOQuadFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOQuadFunctionTest {
    @Test
    public void testAccept() throws IOException {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        AtomicReference ref4 = new AtomicReference();
        IOQuadFunction<AtomicReference, AtomicReference, AtomicReference, AtomicReference, String> quad = (t2, u, v, w) -> {
            ref1.set(Byte.valueOf("1"));
            ref2.set((short)1);
            ref3.set("z");
            ref4.set(2L);
            return "ABCD";
        };
        Assertions.assertEquals((Object)"ABCD", (Object)quad.apply(ref1, ref2, ref3, ref4));
        Assertions.assertEquals((Byte)Byte.valueOf("1"), (Byte)((Byte)ref1.get()));
        Assertions.assertEquals((Short)1, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"z", ref3.get());
        Assertions.assertEquals((Long)2L, (Long)((Long)ref4.get()));
    }

    @Test
    public void testAndThenIOFunction() throws IOException {
        AtomicReference ref1 = new AtomicReference();
        AtomicReference ref2 = new AtomicReference();
        AtomicReference ref3 = new AtomicReference();
        AtomicReference ref4 = new AtomicReference();
        IOQuadFunction<AtomicReference, AtomicReference, AtomicReference, AtomicReference, String> quad = (t2, u, v, w) -> {
            ref1.set(Byte.valueOf("1"));
            ref2.set((short)1);
            ref3.set("z");
            ref4.set(2L);
            return "9";
        };
        IOFunction<String, BigInteger> after = t2 -> {
            ref1.set(Byte.valueOf("2"));
            ref2.set((short)2);
            ref3.set("zz");
            ref4.set(3L);
            return BigInteger.valueOf(Long.parseLong(t2)).add(BigInteger.ONE);
        };
        Assertions.assertEquals((Object)BigInteger.TEN, (Object)quad.andThen(after).apply(ref1, ref2, ref3, ref4));
        Assertions.assertEquals((Byte)Byte.valueOf("2"), (Byte)((Byte)ref1.get()));
        Assertions.assertEquals((Short)2, (Short)((Short)ref2.get()));
        Assertions.assertEquals((Object)"zz", ref3.get());
        Assertions.assertEquals((Long)3L, (Long)((Long)ref4.get()));
    }
}

