/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.function.IOTriConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOTriConsumerTest {
    @Test
    public void testAccept() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOTriConsumer<String, Integer, Character> consumer = (s2, i, b) -> ref.set(s2 + i + b);
        consumer.accept("A", 1, Character.valueOf('b'));
        Assertions.assertEquals((Object)"A1b", ref.get());
    }

    @Test
    public void testAndThen() throws IOException {
        AtomicReference ref = new AtomicReference();
        IOTriConsumer<String, Integer, Character> consumer1 = (s2, i, b) -> ref.set(s2 + i + b);
        IOTriConsumer<String, Integer, Character> consumer2 = (s2, i, b) -> ref.set((String)ref.get() + b + i + s2);
        consumer1.andThen(consumer2).accept("B", 2, Character.valueOf('b'));
        Assertions.assertEquals((Object)"B2bb2B", ref.get());
    }

    @Test
    public void testNoop() throws IOException {
        IOTriConsumer.noop().accept(null, null, null);
    }
}

