/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import org.apache.commons.io.input.BrokenReader;
import org.apache.commons.io.input.ClosedReader;
import org.apache.commons.io.input.UncheckedFilterReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UncheckedFilterReaderTest {
    private UncheckedFilterReader ucStringReader;
    private UncheckedFilterReader ucBrokenReader;
    private IOException exception = new IOException("test exception");

    @BeforeEach
    public void beforeEach() {
        this.ucStringReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(new StringReader("01"))).get();
        this.exception = new IOException("test exception");
        this.ucBrokenReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(new BrokenReader(this.exception))).get();
    }

    @Test
    public void testClose() {
        this.ucStringReader.close();
        Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read());
    }

    @Test
    public void testCloseThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.close())).getCause());
    }

    @Test
    public void testMarkReset() {
        this.ucStringReader.mark(10);
        int c = this.ucStringReader.read();
        this.ucStringReader.reset();
        Assertions.assertEquals((int)c, (int)this.ucStringReader.read());
    }

    @Test
    public void testMarkThrows() {
        try (UncheckedFilterReader closedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(ClosedReader.INSTANCE)).get();){
            closedReader.close();
            Assertions.assertThrows(UncheckedIOException.class, () -> closedReader.mark(1));
        }
    }

    @Test
    public void testRead() {
        UncheckedFilterReader reader = this.ucStringReader;
        try (UncheckedFilterReader uncheckedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(reader)).get();){
            Assertions.assertEquals((int)48, (int)uncheckedReader.read());
            Assertions.assertEquals((int)49, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read());
        }
    }

    @Test
    public void testReadCharArray() {
        UncheckedFilterReader reader = this.ucStringReader;
        try (UncheckedFilterReader uncheckedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(reader)).get();){
            char[] array = new char[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((char)'0', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((char)'1', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    public void testReadCharArrayIndexed() {
        UncheckedFilterReader reader = this.ucStringReader;
        try (UncheckedFilterReader uncheckedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(reader)).get();){
            char[] array = new char[1];
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((char)'0', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((char)'1', (char)array[0]);
            array[0] = '\u0000';
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(array, 0, 1));
            Assertions.assertEquals((int)0, (int)array[0]);
        }
    }

    @Test
    public void testReadCharArrayIndexedThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(new char[1], 0, 1))).getCause());
    }

    @Test
    public void testReadCharArrayThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(new char[1]))).getCause());
    }

    @Test
    public void testReadCharBuffer() {
        UncheckedFilterReader reader = this.ucStringReader;
        try (UncheckedFilterReader uncheckedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(reader)).get();){
            CharBuffer buffer = CharBuffer.wrap(new char[1]);
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((char)'0', (char)buffer.charAt(0));
            buffer.put(0, '\u0000');
            Assertions.assertEquals((int)1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((char)'1', (char)buffer.charAt(0));
            buffer.put(0, '\u0000');
            Assertions.assertEquals((int)-1, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((int)0, (int)buffer.length());
            Assertions.assertEquals((int)0, (int)uncheckedReader.read(buffer));
            buffer.flip();
            Assertions.assertEquals((int)0, (int)buffer.length());
        }
    }

    @Test
    public void testReadCharBufferThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read(CharBuffer.wrap(new char[1])))).getCause());
    }

    @Test
    public void testReadThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.read())).getCause());
    }

    @Test
    public void testReady() {
        Assertions.assertTrue((boolean)this.ucStringReader.ready());
    }

    @Test
    public void testReadyThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.ready())).getCause());
    }

    @Test
    public void testResetThrows() {
        try (UncheckedFilterReader closedReader = ((UncheckedFilterReader.Builder)UncheckedFilterReader.builder().setReader(ClosedReader.INSTANCE)).get();){
            closedReader.close();
            Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.reset());
        }
    }

    @Test
    public void testSkip() {
        Assertions.assertEquals((long)1L, (long)this.ucStringReader.skip(1L));
    }

    @Test
    public void testSkipThrows() {
        Assertions.assertEquals((Object)this.exception, (Object)((UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.ucBrokenReader.skip(1L))).getCause());
    }
}

