/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedFilterInputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnsynchronizedFilterInputStreamTest {
    public static final String DATA = StringUtils.repeat((String)"This is a test.", (int)500);
    private Path fileName;
    private InputStream is;
    byte[] ibuf = new byte[4096];

    @BeforeEach
    protected void setUp() throws IOException {
        this.fileName = Files.createTempFile(this.getClass().getSimpleName(), ".tst", new FileAttribute[0]);
        Files.write(this.fileName, DATA.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.is = ((UnsynchronizedFilterInputStream.Builder)UnsynchronizedFilterInputStream.builder().setInputStream(Files.newInputStream(this.fileName, new OpenOption[0]))).get();
    }

    @AfterEach
    protected void tearDown() throws IOException {
        IOUtils.closeQuietly(this.is);
        Files.deleteIfExists(this.fileName);
    }

    @Test
    public void test_available() throws IOException {
        Assertions.assertEquals((int)DATA.length(), (int)this.is.available(), (String)"Returned incorrect number of available bytes");
    }

    @Test
    public void test_close() throws IOException {
        this.is.close();
        Assertions.assertThrows(IOException.class, () -> this.is.read(), (String)"Able to read from closed stream");
    }

    @Test
    public void test_markI() {
        Assertions.assertTrue((boolean)true, (String)"Mark not supported by parent InputStream");
    }

    @Test
    public void test_markSupported() {
        Assertions.assertTrue((!this.is.markSupported() ? 1 : 0) != 0, (String)"markSupported returned true");
    }

    @Test
    public void test_read() throws IOException {
        int c = this.is.read();
        Assertions.assertEquals((int)DATA.charAt(0), (int)c, (String)"read returned incorrect char");
    }

    @Test
    public void test_read$B() throws IOException {
        byte[] buf1 = new byte[100];
        Assertions.assertEquals((int)buf1.length, (int)this.is.read(buf1));
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length, StandardCharsets.UTF_8).equals(DATA.substring(0, 100)), (String)"Failed to read correct data");
    }

    @Test
    public void test_read$BII() throws IOException {
        byte[] buf1 = new byte[100];
        this.is.skip(3000L);
        this.is.mark(1000);
        this.is.read(buf1, 0, buf1.length);
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length, StandardCharsets.UTF_8).equals(DATA.substring(3000, 3100)), (String)"Failed to read correct data");
    }

    @Test
    public void test_reset() {
        Assertions.assertThrows(IOException.class, () -> this.is.reset(), (String)"should throw IOException");
    }

    @Test
    public void test_skipJ() throws IOException {
        byte[] buf1 = new byte[10];
        this.is.skip(1000L);
        this.is.read(buf1, 0, buf1.length);
        Assertions.assertTrue((boolean)new String(buf1, 0, buf1.length, StandardCharsets.UTF_8).equals(DATA.substring(1000, 1010)), (String)"Failed to skip to correct position");
    }
}

