/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.XmlStreamReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junitpioneer.jupiter.DefaultLocale;

public class XmlStreamReaderTest {
    private static final String ISO_8859_1 = StandardCharsets.ISO_8859_1.name();
    private static final String US_ASCII = StandardCharsets.US_ASCII.name();
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final String UTF_16LE = StandardCharsets.UTF_16LE.name();
    private static final String UTF_16BE = StandardCharsets.UTF_16BE.name();
    private static final String UTF_32 = "UTF-32";
    private static final String UTF_32LE = "UTF-32LE";
    private static final String UTF_32BE = "UTF-32BE";
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String XML7 = "xml-prolog-encoding-no-version";
    private static final String XML6 = "xml-prolog-encoding-new-line";
    private static final String XML5 = "xml-prolog-encoding-spaced-single-quotes";
    private static final String XML4 = "xml-prolog-encoding-single-quotes";
    private static final String XML3 = "xml-prolog-encoding-double-quotes";
    private static final String XML2 = "xml-prolog";
    private static final String XML1 = "xml";
    private static final String ENCODING_ATTRIBUTE_XML = "<?xml version=\"1.0\" ?> \n<atom:feed xmlns:atom=\"http://www.w3.org/2005/Atom\">\n\n  <atom:entry>\n    <atom:title encoding='base64'><![CDATA\naW5nTGluZSIgLz4";
    private static final int[] NO_BOM_BYTES = new int[0];
    private static final int[] UTF_16BE_BOM_BYTES = new int[]{254, 255};
    private static final int[] UTF_16LE_BOM_BYTES = new int[]{255, 254};
    private static final int[] UTF_32BE_BOM_BYTES = new int[]{0, 0, 254, 255};
    private static final int[] UTF_32LE_BOM_BYTES = new int[]{255, 254, 0, 0};
    private static final int[] UTF_8_BOM_BYTES = new int[]{239, 187, 191};
    private static final Map<String, int[]> BOMs = new HashMap<String, int[]>();
    private static final MessageFormat XML;
    private static final MessageFormat XML_WITH_PROLOG;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_NEW_LINES;
    private static final MessageFormat XML_EXTERNAL_PARSED_ENTITY_NO_VERSION;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES;
    private static final MessageFormat XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES;
    private static final MessageFormat INFO;
    private static final Map<String, MessageFormat> XMLs;

    private String getXML(String bomType, String xmlType, String streamEnc, String prologEnc) {
        MessageFormat xml = XMLs.get(xmlType);
        String info = INFO.format(new Object[]{bomType, xmlType, prologEnc});
        return xml.format(new Object[]{streamEnc, prologEnc, info});
    }

    protected InputStream getXmlInputStream(String bomType, String xmlType, String streamEnc, String prologEnc) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        int[] bom = BOMs.get(bomType);
        if (bom == null) {
            bom = new int[]{};
        }
        for (int element : bom) {
            baos.write(element);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, streamEnc);){
            String xmlDoc = this.getXML(bomType, xmlType, streamEnc, prologEnc);
            writer.write(xmlDoc);
            writer.write("<da>\n");
            for (int i = 0; i < 10000; ++i) {
                writer.write("<do/>\n");
            }
            writer.write("</da>\n");
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void parseCharset(String hdr, String enc, IOFunction<InputStream, XmlStreamReader> factory) throws Exception {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(hdr.getBytes(StandardCharsets.UTF_8));
             XmlStreamReader xml = factory.apply(stream);){
            Assertions.assertEquals((Object)enc.toUpperCase(Locale.ROOT), (Object)xml.getEncoding(), (String)enc);
        }
    }

    public void testAlternateDefaultEncoding(String contentType, String bomEnc, String streamEnc, String prologEnc, String alternateEnc) throws Exception {
        XmlStreamReader xmlReader;
        try (InputStream is = this.getXmlInputStream(bomEnc, prologEnc == null ? XML1 : XML3, streamEnc, prologEnc);){
            xmlReader = new XmlStreamReader(is, contentType, false, alternateEnc);
            try {
                this.testAlternateDefaultEncoding(streamEnc, alternateEnc, xmlReader);
            }
            finally {
                xmlReader.close();
            }
        }
        is = this.getXmlInputStream(bomEnc, prologEnc == null ? XML1 : XML3, streamEnc, prologEnc);
        try {
            xmlReader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(is)).setHttpContentType(contentType).setLenient(false).setCharset(alternateEnc).get();
            try {
                this.testAlternateDefaultEncoding(streamEnc, alternateEnc, xmlReader);
            }
            finally {
                if (xmlReader != null) {
                    xmlReader.close();
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private void testAlternateDefaultEncoding(String streamEnc, String alternateEnc, XmlStreamReader xmlReader) {
        Assertions.assertEquals((Object)xmlReader.getDefaultEncoding(), (Object)alternateEnc);
        if (!streamEnc.equals(UTF_16)) {
            String enc = alternateEnc != null ? alternateEnc : streamEnc;
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)enc);
        } else {
            Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, streamEnc.length()), (Object)streamEnc);
        }
    }

    @Test
    protected void testConstructorFileInput() throws IOException {
        XmlStreamReader reader = new XmlStreamReader(new File("pom.xml"));
        reader.close();
        reader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setFile("pom.xml")).get();
        if (reader != null) {
            reader.close();
        }
    }

    @Test
    protected void testConstructorFileInputNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((File)null));
    }

    @Test
    protected void testConstructorFileInputOpenOptions() throws IOException {
        XmlStreamReader reader = new XmlStreamReader(new File("pom.xml"));
        reader.close();
        reader = ((XmlStreamReader.Builder)((XmlStreamReader.Builder)XmlStreamReader.builder().setFile("pom.xml")).setOpenOptions(StandardOpenOption.READ)).get();
        if (reader != null) {
            reader.close();
        }
    }

    @Test
    protected void testConstructorInputStreamInput() throws IOException {
        Path path = Paths.get("pom.xml", new String[0]);
        XmlStreamReader reader = new XmlStreamReader(Files.newInputStream(path, new OpenOption[0]));
        reader.close();
        reader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(Files.newInputStream(path, new OpenOption[0]))).get();
        if (reader != null) {
            reader.close();
        }
    }

    @Test
    protected void testConstructorInputStreamInputNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((InputStream)null));
    }

    @Test
    protected void testConstructorPathInput() throws IOException {
        XmlStreamReader reader = new XmlStreamReader(Paths.get("pom.xml", new String[0]));
        reader.close();
        reader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setPath("pom.xml")).get();
        if (reader != null) {
            reader.close();
        }
    }

    @Test
    protected void testConstructorPathInputNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((Path)null));
    }

    @Test
    protected void testConstructorURLConnectionInput() throws IOException {
        XmlStreamReader reader = new XmlStreamReader(new URL("https://www.apache.org/").openConnection(), UTF_8);
        reader.close();
    }

    @Test
    protected void testConstructorURLConnectionInputNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((URLConnection)null, US_ASCII));
    }

    @Test
    protected void testConstructorURLInput() throws IOException {
        XmlStreamReader reader = new XmlStreamReader(new URL("https://www.apache.org/"));
        reader.close();
    }

    @Test
    protected void testConstructorURLInputNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new XmlStreamReader((URL)null));
    }

    @Test
    public void testEncodingAttributeXML() throws Exception {
        XmlStreamReader xmlReader;
        try (ByteArrayInputStream is = new ByteArrayInputStream(ENCODING_ATTRIBUTE_XML.getBytes(StandardCharsets.UTF_8));){
            xmlReader = new XmlStreamReader((InputStream)is, "", true);
            try {
                Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)UTF_8);
            }
            finally {
                xmlReader.close();
            }
        }
        is = new ByteArrayInputStream(ENCODING_ATTRIBUTE_XML.getBytes(StandardCharsets.UTF_8));
        try {
            xmlReader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(is)).setHttpContentType("").setLenient(true).get();
            try {
                Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)UTF_8);
            }
            finally {
                if (xmlReader != null) {
                    xmlReader.close();
                }
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Test
    public void testHttp() throws Exception {
        this.testHttpValid("application/xml", "UTF-8-bom", UTF_8, null);
        this.testHttpValid("application/xml", "UTF-8-bom", UTF_8, UTF_8);
        this.testHttpValid("application/xml;charset=UTF-8", "UTF-8-bom", UTF_8, null);
        this.testHttpValid("application/xml;charset=\"UTF-8\"", "UTF-8-bom", UTF_8, null);
        this.testHttpValid("application/xml;charset='UTF-8'", "UTF-8-bom", UTF_8, null);
        this.testHttpValid("application/xml;charset=UTF-8", "UTF-8-bom", UTF_8, UTF_8);
        this.testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, null);
        this.testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16);
        this.testHttpValid("application/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16BE);
        this.testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, null);
        this.testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16);
        this.testHttpInvalid("application/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16BE);
        this.testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, null);
        this.testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32);
        this.testHttpInvalid("application/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32BE);
        this.testHttpInvalid("application/xml", "UTF-8-bom", US_ASCII, US_ASCII);
        this.testHttpInvalid("application/xml;charset=UTF-16", UTF_16LE, UTF_8, UTF_8);
        this.testHttpInvalid("application/xml;charset=UTF-16", "no-bom", UTF_16BE, UTF_16BE);
        this.testHttpInvalid("application/xml;charset=UTF-32", UTF_32LE, UTF_8, UTF_8);
        this.testHttpInvalid("application/xml;charset=UTF-32", "no-bom", UTF_32BE, UTF_32BE);
        this.testHttpValid("text/xml", "no-bom", US_ASCII, null);
        this.testHttpValid("text/xml;charset=UTF-8", "UTF-8-bom", UTF_8, UTF_8);
        this.testHttpValid("text/xml;charset=UTF-8", "UTF-8-bom", UTF_8, null);
        this.testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, null);
        this.testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16);
        this.testHttpValid("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16BE);
        this.testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, null);
        this.testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, UTF_32);
        this.testHttpValid("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, UTF_32BE);
        this.testHttpValid("text/xml", "UTF-8-bom", US_ASCII, null);
        this.testAlternateDefaultEncoding("application/xml", "UTF-8-bom", UTF_8, null, null);
        this.testAlternateDefaultEncoding("application/xml", "no-bom", US_ASCII, null, US_ASCII);
        this.testAlternateDefaultEncoding("application/xml", "UTF-8-bom", UTF_8, null, UTF_8);
        this.testAlternateDefaultEncoding("text/xml", "no-bom", US_ASCII, null, null);
        this.testAlternateDefaultEncoding("text/xml", "no-bom", US_ASCII, null, US_ASCII);
        this.testAlternateDefaultEncoding("text/xml", "no-bom", US_ASCII, null, UTF_8);
        this.testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, null);
        this.testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16);
        this.testHttpInvalid("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16BE);
        this.testHttpInvalid("text/xml;charset=UTF-16", "no-bom", UTF_16BE, UTF_16BE);
        this.testHttpInvalid("text/xml;charset=UTF-16", "no-bom", UTF_16BE, null);
        this.testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, null);
        this.testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32);
        this.testHttpInvalid("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32BE);
        this.testHttpInvalid("text/xml;charset=UTF-32", "no-bom", UTF_32BE, UTF_32BE);
        this.testHttpInvalid("text/xml;charset=UTF-32", "no-bom", UTF_32BE, null);
        this.testHttpLenient("text/xml", "no-bom", US_ASCII, null, US_ASCII);
        this.testHttpLenient("text/xml;charset=UTF-8", "UTF-8-bom", UTF_8, UTF_8, UTF_8);
        this.testHttpLenient("text/xml;charset=UTF-8", "UTF-8-bom", UTF_8, null, UTF_8);
        this.testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, null, UTF_16BE);
        this.testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16, UTF_16);
        this.testHttpLenient("text/xml;charset=UTF-16", "UTF-16BE-bom", UTF_16BE, UTF_16BE, UTF_16BE);
        this.testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, null, UTF_32BE);
        this.testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, UTF_32, UTF_32);
        this.testHttpLenient("text/xml;charset=UTF-32", "UTF-32BE-bom", UTF_32BE, UTF_32BE, UTF_32BE);
        this.testHttpLenient("text/xml", "UTF-8-bom", US_ASCII, null, US_ASCII);
        this.testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, null, UTF_16BE);
        this.testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16, UTF_16);
        this.testHttpLenient("text/xml;charset=UTF-16BE", "UTF-16BE-bom", UTF_16BE, UTF_16BE, UTF_16BE);
        this.testHttpLenient("text/xml;charset=UTF-16", "no-bom", UTF_16BE, UTF_16BE, UTF_16BE);
        this.testHttpLenient("text/xml;charset=UTF-16", "no-bom", UTF_16BE, null, UTF_16);
        this.testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, null, UTF_32BE);
        this.testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32, UTF_32);
        this.testHttpLenient("text/xml;charset=UTF-32BE", "UTF-32BE-bom", UTF_32BE, UTF_32BE, UTF_32BE);
        this.testHttpLenient("text/xml;charset=UTF-32", "no-bom", UTF_32BE, UTF_32BE, UTF_32BE);
        this.testHttpLenient("text/xml;charset=UTF-32", "no-bom", UTF_32BE, null, UTF_32);
        this.testHttpLenient("text/html", "no-bom", US_ASCII, US_ASCII, US_ASCII);
        this.testHttpLenient("text/html", "no-bom", US_ASCII, null, US_ASCII);
        this.testHttpLenient("text/html;charset=UTF-8", "no-bom", US_ASCII, UTF_8, UTF_8);
        this.testHttpLenient("text/html;charset=UTF-16BE", "no-bom", US_ASCII, UTF_8, UTF_8);
        this.testHttpLenient("text/html;charset=UTF-32BE", "no-bom", US_ASCII, UTF_8, UTF_8);
    }

    @Test
    public void testHttpContent() throws Exception {
        String encoding = UTF_8;
        String xml = this.getXML("no-bom", XML3, encoding, encoding);
        try (XmlStreamReader xmlReader = new XmlStreamReader(((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence(xml)).setCharset(encoding)).get());){
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding, (String)"Check encoding");
            Assertions.assertEquals((Object)xml, (Object)IOUtils.toString(xmlReader), (String)"Check content");
        }
    }

    protected void testHttpInvalid(String cT, String bomEnc, String streamEnc, String prologEnc) throws Exception {
        try (InputStream is = this.getXmlInputStream(bomEnc, prologEnc == null ? XML2 : XML3, streamEnc, prologEnc);){
            try {
                new XmlStreamReader(is, cT, false).close();
                Assertions.fail((String)("It should have failed for HTTP Content-type " + cT + ", BOM " + bomEnc + ", streamEnc " + streamEnc + " and prologEnc " + prologEnc));
            }
            catch (IOException ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("Illegal encoding,"));
            }
        }
    }

    protected void testHttpLenient(String cT, String bomEnc, String streamEnc, String prologEnc, String shouldBe) throws Exception {
        try (InputStream is = this.getXmlInputStream(bomEnc, prologEnc == null ? XML2 : XML3, streamEnc, prologEnc);
             XmlStreamReader xmlReader = new XmlStreamReader(is, cT, true);){
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)shouldBe);
        }
    }

    public void testHttpValid(String cT, String bomEnc, String streamEnc, String prologEnc) throws Exception {
        try (InputStream is = this.getXmlInputStream(bomEnc, prologEnc == null ? XML1 : XML3, streamEnc, prologEnc);
             XmlStreamReader xmlReader = new XmlStreamReader(is, cT, false);){
            if (!streamEnc.equals(UTF_16)) {
                Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)streamEnc);
            } else {
                Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, streamEnc.length()), (Object)streamEnc);
            }
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#availableCharsetsKeySet"})
    public void testIO_815(String csName) throws Exception {
        MessageFormat fmt = new MessageFormat("<?xml version=\"1.0\" encoding=''{0}''?>\n<root>text</root>");
        IOFunction<InputStream, XmlStreamReader> factoryCtor = XmlStreamReader::new;
        IOFunction<InputStream, XmlStreamReader> factoryBuilder = stream -> ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream((InputStream)stream)).get();
        this.parseCharset(fmt.format(new Object[]{csName}), csName, factoryCtor);
        this.parseCharset(fmt.format(new Object[]{csName}), csName, factoryBuilder);
        for (String alias : Charset.forName(csName).aliases()) {
            this.parseCharset(fmt.format(new Object[]{alias}), alias, factoryCtor);
            this.parseCharset(fmt.format(new Object[]{alias}), alias, factoryBuilder);
        }
    }

    @Test
    @DefaultLocale(language="tr")
    public void testLowerCaseEncodingWithTurkishLocale_IO_557() throws Exception {
        String[] encodings;
        for (String encoding : encodings = new String[]{"iso8859-1", "us-ascii", "utf-8"}) {
            String xml = this.getXML("no-bom", XML3, encoding, encoding);
            try (ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(encoding));
                 XmlStreamReader xmlReader = new XmlStreamReader(is);){
                Assertions.assertTrue((boolean)encoding.equalsIgnoreCase(xmlReader.getEncoding()), (String)("Check encoding : " + encoding));
                Assertions.assertEquals((Object)xml, (Object)IOUtils.toString(xmlReader), (String)"Check content");
            }
        }
    }

    protected void testRawBomInvalid(String bomEnc, String streamEnc, String prologEnc) throws Exception {
        InputStream is = this.getXmlInputStream(bomEnc, XML3, streamEnc, prologEnc);
        XmlStreamReader xmlReader = null;
        try {
            xmlReader = ((XmlStreamReader.Builder)XmlStreamReader.builder().setInputStream(is)).setLenient(false).get();
            String foundEnc = xmlReader.getEncoding();
            Assertions.fail((String)("Expected IOException for BOM " + bomEnc + ", streamEnc " + streamEnc + " and prologEnc " + prologEnc + ": found " + foundEnc));
        }
        catch (IOException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Illegal encoding,"));
        }
        if (xmlReader != null) {
            xmlReader.close();
        }
    }

    @Test
    public void testRawBomUtf16() throws Exception {
        this.testRawBomValid(UTF_16BE);
        this.testRawBomValid(UTF_16LE);
        this.testRawBomValid(UTF_16);
        this.testRawBomInvalid("UTF-16BE-bom", UTF_16BE, UTF_16LE);
        this.testRawBomInvalid("UTF-16LE-bom", UTF_16LE, UTF_16BE);
        this.testRawBomInvalid("UTF-16LE-bom", UTF_16LE, UTF_8);
    }

    @Test
    public void testRawBomUtf32() throws Exception {
        this.testRawBomValid(UTF_32BE);
        this.testRawBomValid(UTF_32LE);
        this.testRawBomValid(UTF_32);
        this.testRawBomInvalid("UTF-32BE-bom", UTF_32BE, UTF_32LE);
        this.testRawBomInvalid("UTF-32LE-bom", UTF_32LE, UTF_32BE);
        this.testRawBomInvalid("UTF-32LE-bom", UTF_32LE, UTF_8);
    }

    @Test
    public void testRawBomUtf8() throws Exception {
        this.testRawBomValid(UTF_8);
        this.testRawBomInvalid("UTF-8-bom", US_ASCII, US_ASCII);
        this.testRawBomInvalid("UTF-8-bom", ISO_8859_1, ISO_8859_1);
        this.testRawBomInvalid("UTF-8-bom", UTF_8, UTF_16);
        this.testRawBomInvalid("UTF-8-bom", UTF_8, UTF_16BE);
        this.testRawBomInvalid("UTF-8-bom", UTF_8, UTF_16LE);
        this.testRawBomInvalid("UTF-16BE-bom", UTF_16BE, UTF_16LE);
        this.testRawBomInvalid("UTF-16LE-bom", UTF_16LE, UTF_16BE);
        this.testRawBomInvalid("UTF-16LE-bom", UTF_16LE, UTF_8);
        this.testRawBomInvalid("UTF-32BE-bom", UTF_32BE, UTF_32LE);
        this.testRawBomInvalid("UTF-32LE-bom", UTF_32LE, UTF_32BE);
        this.testRawBomInvalid("UTF-32LE-bom", UTF_32LE, UTF_8);
    }

    protected void testRawBomValid(String encoding) throws Exception {
        try (InputStream is = this.getXmlInputStream(encoding + "-bom", XML3, encoding, encoding);
             XmlStreamReader xmlReader = new XmlStreamReader(is, false);){
            if (!encoding.equals(UTF_16) && !encoding.equals(UTF_32)) {
                Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
            } else {
                Assertions.assertEquals((Object)xmlReader.getEncoding().substring(0, encoding.length()), (Object)encoding);
            }
        }
    }

    @Test
    public void testRawContent() throws Exception {
        String encoding = UTF_8;
        String xml = this.getXML("no-bom", XML3, encoding, encoding);
        try (XmlStreamReader xmlReader = new XmlStreamReader(((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence(xml)).setCharset(encoding)).get());){
            Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding, (String)"Check encoding");
            Assertions.assertEquals((Object)xml, (Object)IOUtils.toString(xmlReader), (String)"Check content");
        }
    }

    @Test
    public void testRawNoBomCp1047() throws Exception {
        this.testRawNoBomValid("CP1047");
    }

    protected void testRawNoBomInvalid(String encoding) throws Exception {
        try (InputStream is = this.getXmlInputStream("no-bom", XML3, encoding, encoding);){
            XmlStreamReader xmlStreamReader = new XmlStreamReader(is, false);
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, xmlStreamReader::close);
            Assertions.assertTrue((boolean)ex.getMessage().contains("Invalid encoding,"));
        }
    }

    @Test
    public void testRawNoBomIso8859_1() throws Exception {
        this.testRawNoBomValid(ISO_8859_1);
    }

    @Test
    public void testRawNoBomUsAscii() throws Exception {
        this.testRawNoBomValid(US_ASCII);
    }

    @Test
    public void testRawNoBomUtf16BE() throws Exception {
        this.testRawNoBomValid(UTF_16BE);
    }

    @Test
    public void testRawNoBomUtf16LE() throws Exception {
        this.testRawNoBomValid(UTF_16LE);
    }

    @Test
    public void testRawNoBomUtf32BE() throws Exception {
        this.testRawNoBomValid(UTF_32BE);
    }

    @Test
    public void testRawNoBomUtf32LE() throws Exception {
        this.testRawNoBomValid(UTF_32LE);
    }

    @Test
    public void testRawNoBomUtf8() throws Exception {
        this.testRawNoBomValid(UTF_8);
    }

    protected void testRawNoBomValid(String encoding) throws Exception {
        InputStream is = this.getXmlInputStream("no-bom", XML1, encoding, encoding);
        XmlStreamReader xmlReader = new XmlStreamReader(is, false);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)UTF_8);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML2, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)UTF_8);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML3, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML4, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML5, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML6, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
        is = this.getXmlInputStream("no-bom", XML7, encoding, encoding);
        xmlReader = new XmlStreamReader(is);
        Assertions.assertEquals((Object)xmlReader.getEncoding(), (Object)encoding);
        xmlReader.close();
    }

    static {
        BOMs.put("no-bom", NO_BOM_BYTES);
        BOMs.put("UTF-16BE-bom", UTF_16BE_BOM_BYTES);
        BOMs.put("UTF-16LE-bom", UTF_16LE_BOM_BYTES);
        BOMs.put("UTF-32BE-bom", UTF_32BE_BOM_BYTES);
        BOMs.put("UTF-32LE-bom", UTF_32LE_BOM_BYTES);
        BOMs.put("UTF-16-bom", NO_BOM_BYTES);
        BOMs.put("UTF-8-bom", UTF_8_BOM_BYTES);
        XML = new MessageFormat("<root>{2}</root>");
        XML_WITH_PROLOG = new MessageFormat("<?xml version=\"1.0\"?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_NEW_LINES = new MessageFormat("<?xml\nversion\n=\n\"1.0\"\nencoding\n=\n\"{1}\"\n?>\n<root>{2}</root>");
        XML_EXTERNAL_PARSED_ENTITY_NO_VERSION = new MessageFormat("<?xml\nencoding\n=\n\"{1}\"\n?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding=\"{1}\"?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding=''{1}''?>\n<root>{2}</root>");
        XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES = new MessageFormat("<?xml version=\"1.0\" encoding =  \t \n \r''{1}''?>\n<root>{2}</root>");
        INFO = new MessageFormat("\nBOM : {0}\nDoc : {1}\nStream Enc : {2}\nProlog Enc : {3}\n");
        XMLs = new HashMap<String, MessageFormat>();
        XMLs.put(XML1, XML);
        XMLs.put(XML2, XML_WITH_PROLOG);
        XMLs.put(XML3, XML_WITH_PROLOG_AND_ENCODING_DOUBLE_QUOTES);
        XMLs.put(XML4, XML_WITH_PROLOG_AND_ENCODING_SINGLE_QUOTES);
        XMLs.put(XML5, XML_WITH_PROLOG_AND_ENCODING_SPACED_SINGLE_QUOTES);
        XMLs.put(XML6, XML_WITH_PROLOG_AND_ENCODING_NEW_LINES);
        XMLs.put(XML7, XML_EXTERNAL_PARSED_ENTITY_NO_VERSION);
    }
}

