/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.jmh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
@Fork(value=1, jvmArgs={"-server"})
public class IOUtilsContentEqualsReadersBenchmark {
    private static final int STRING_LEN = 0x1000000;
    private static final String TEST_PATH_A = "/org/apache/commons/io/testfileBOM.xml";
    private static final String TEST_PATH_16K_A = "/org/apache/commons/io/abitmorethan16k.txt";
    private static final String TEST_PATH_16K_A_COPY = "/org/apache/commons/io/abitmorethan16kcopy.txt";
    private static final String TEST_PATH_B = "/org/apache/commons/io/testfileNoBOM.xml";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    static String[] STRINGS = new String[5];
    static String SPECIAL_CASE_STRING_0;
    static String SPECIAL_CASE_STRING_1;

    public static boolean contentEquals_release_2_8_0(Reader input1, Reader input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedReader bufferedInput1 = IOUtils.toBufferedReader(input1);
        BufferedReader bufferedInput2 = IOUtils.toBufferedReader(input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    public static boolean contentEqualsPr118(Reader input1, Reader input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null || input2 == null) {
            return false;
        }
        char[] array1 = new char[8192];
        char[] array2 = new char[8192];
        block0: while (true) {
            int pos1 = 0;
            int pos2 = 0;
            int index = 0;
            while (true) {
                if (index >= 8192) continue block0;
                if (pos1 == index) {
                    int count1;
                    while ((count1 = input1.read(array1, pos1, 8192 - pos1)) == 0) {
                    }
                    if (count1 == -1) {
                        return pos2 == index && input2.read() == -1;
                    }
                    pos1 += count1;
                }
                if (pos2 == index) {
                    int count2;
                    while ((count2 = input2.read(array2, pos2, 8192 - pos2)) == 0) {
                    }
                    if (count2 == -1) {
                        return pos1 == index && input1.read() == -1;
                    }
                    pos2 += count2;
                }
                if (array1[index] != array2[index]) {
                    return false;
                }
                ++index;
            }
            break;
        }
    }

    @Benchmark
    public boolean[] testFileCurrent() throws IOException {
        InputStreamReader input2;
        boolean[] res = new boolean[3];
        try (InputStreamReader input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);){
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_B), DEFAULT_CHARSET);
            try {
                res[0] = IOUtils.contentEquals(input1, input1);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
            try {
                res[1] = IOUtils.contentEquals(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A), DEFAULT_CHARSET);
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY), DEFAULT_CHARSET);
            try {
                res[2] = IOUtils.contentEquals(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        return res;
    }

    @Benchmark
    public boolean[] testFilePr118() throws IOException {
        InputStreamReader input2;
        boolean[] res = new boolean[3];
        try (InputStreamReader input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);){
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_B), DEFAULT_CHARSET);
            try {
                res[0] = IOUtilsContentEqualsReadersBenchmark.contentEqualsPr118(input1, input1);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
            try {
                res[1] = IOUtilsContentEqualsReadersBenchmark.contentEqualsPr118(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A));
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY));
            try {
                res[2] = IOUtilsContentEqualsReadersBenchmark.contentEqualsPr118(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        return res;
    }

    @Benchmark
    public boolean[] testFileRelease_2_8_0() throws IOException {
        InputStreamReader input2;
        boolean[] res = new boolean[3];
        try (InputStreamReader input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);){
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_B), DEFAULT_CHARSET);
            try {
                res[0] = IOUtilsContentEqualsReadersBenchmark.contentEquals_release_2_8_0(input1, input1);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_A), DEFAULT_CHARSET);
            try {
                res[1] = IOUtilsContentEqualsReadersBenchmark.contentEquals_release_2_8_0(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        input1 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A), DEFAULT_CHARSET);
        try {
            input2 = new InputStreamReader(this.getClass().getResourceAsStream(TEST_PATH_16K_A_COPY), DEFAULT_CHARSET);
            try {
                res[2] = IOUtilsContentEqualsReadersBenchmark.contentEquals_release_2_8_0(input1, input2);
            }
            finally {
                ((Reader)input2).close();
            }
        }
        finally {
            ((Reader)input1).close();
        }
        return res;
    }

    @Benchmark
    public void testStringCurrent(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (StringReader input1 = new StringReader(STRINGS[i]);
                     StringReader input2 = new StringReader(STRINGS[j]);){
                    blackhole.consume(IOUtils.contentEquals(input1, input2));
                    continue;
                }
            }
        }
    }

    @Benchmark
    public void testStringPr118(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (StringReader input1 = new StringReader(STRINGS[i]);
                     StringReader input2 = new StringReader(STRINGS[j]);){
                    blackhole.consume(IOUtilsContentEqualsReadersBenchmark.contentEqualsPr118(input1, input2));
                    continue;
                }
            }
        }
    }

    @Benchmark
    public void testStringRelease_2_8_0(Blackhole blackhole) throws IOException {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                try (StringReader input1 = new StringReader(STRINGS[i]);
                     StringReader input2 = new StringReader(STRINGS[j]);){
                    blackhole.consume(IOUtilsContentEqualsReadersBenchmark.contentEquals_release_2_8_0(input1, input2));
                    continue;
                }
            }
        }
    }

    static {
        IOUtilsContentEqualsReadersBenchmark.STRINGS[0] = StringUtils.repeat((String)"ab", (int)0x1000000);
        IOUtilsContentEqualsReadersBenchmark.STRINGS[1] = STRINGS[0] + 'c';
        IOUtilsContentEqualsReadersBenchmark.STRINGS[2] = STRINGS[0] + 'd';
        IOUtilsContentEqualsReadersBenchmark.STRINGS[3] = StringUtils.repeat((String)"ab\rab\n", (int)0x1000000);
        IOUtilsContentEqualsReadersBenchmark.STRINGS[4] = StringUtils.repeat((String)"ab\r\nab\r", (int)0x1000000);
        SPECIAL_CASE_STRING_0 = StringUtils.repeat((String)(StringUtils.repeat((String)"ab", (int)0x1000000) + '\n'), (int)2);
        SPECIAL_CASE_STRING_1 = StringUtils.repeat((String)(StringUtils.repeat((String)"cd", (int)0x1000000) + '\n'), (int)2);
    }
}

