/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.output.AbstractByteArrayOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ByteArrayOutputStreamTest {
    private static final byte[] DATA = new byte[64];

    private static Stream<Arguments> baosFactories() {
        return Stream.of(Arguments.of((Object[])new Object[]{ByteArrayOutputStream.class.getSimpleName(), new ByteArrayOutputStreamFactory()}), Arguments.of((Object[])new Object[]{UnsynchronizedByteArrayOutputStream.class.getSimpleName(), new UnsynchronizedByteArrayOutputStreamFactory()}));
    }

    private static boolean byteCmp(byte[] src, byte[] cmp) {
        for (int i = 0; i < cmp.length; ++i) {
            if (src[i] == cmp[i]) continue;
            return false;
        }
        return true;
    }

    private static Stream<Arguments> toBufferedInputStreamFunctionFactories() {
        IOFunction<InputStream, InputStream> syncBaosToBufferedInputStream = ByteArrayOutputStream::toBufferedInputStream;
        IOFunction<InputStream, InputStream> syncBaosToBufferedInputStreamWithSize = is -> ByteArrayOutputStream.toBufferedInputStream(is, 1024);
        IOFunction<InputStream, InputStream> unSyncBaosToBufferedInputStream = UnsynchronizedByteArrayOutputStream::toBufferedInputStream;
        IOFunction<InputStream, InputStream> unSyncBaosToBufferedInputStreamWithSize = is -> UnsynchronizedByteArrayOutputStream.toBufferedInputStream(is, 1024);
        return Stream.of(Arguments.of((Object[])new Object[]{"ByteArrayOutputStream.toBufferedInputStream(InputStream)", syncBaosToBufferedInputStream}), Arguments.of((Object[])new Object[]{"ByteArrayOutputStream.toBufferedInputStream(InputStream, int)", syncBaosToBufferedInputStreamWithSize}), Arguments.of((Object[])new Object[]{"UnsynchronizedByteArrayOutputStream.toBufferedInputStream(InputStream)", unSyncBaosToBufferedInputStream}), Arguments.of((Object[])new Object[]{"UnsynchronizedByteArrayOutputStream.toBufferedInputStream(InputStream, int)", unSyncBaosToBufferedInputStreamWithSize}));
    }

    private void checkByteArrays(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            Assertions.fail((String)"Resulting byte arrays are not equally long");
        }
        if (!ByteArrayOutputStreamTest.byteCmp(expected, actual)) {
            Assertions.fail((String)"Resulting byte arrays are not equal");
        }
    }

    private void checkStreams(AbstractByteArrayOutputStream actual, java.io.ByteArrayOutputStream expected) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Sizes are not equal");
        byte[] buf = actual.toByteArray();
        byte[] refbuf = expected.toByteArray();
        this.checkByteArrays(buf, refbuf);
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidParameterizedConstruction(String baosName, BAOSFactory<?> baosFactory) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> baosFactory.newInstance(-1));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidWriteLenUnder(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> baout.write(new byte[1], 0, -1));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidWriteOffsetAndLenOver(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> baout.write(new byte[1], 0, 2));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidWriteOffsetAndLenUnder(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> baout.write(new byte[1], 1, -2));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidWriteOffsetOver(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> baout.write(IOUtils.EMPTY_BYTE_ARRAY, 1, 0));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testInvalidWriteOffsetUnder(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> baout.write(null, -1, 0));
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testStream(String baosName, BAOSFactory<?> baosFactory) throws Exception {
        try (Object baout = baosFactory.newInstance(32);
             java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();){
            int written = this.writeData((AbstractByteArrayOutputStream)baout, ref, new int[]{4, 10, 22});
            Assertions.assertEquals((int)36, (int)written);
            this.checkStreams((AbstractByteArrayOutputStream)baout, ref);
            written = this.writeData((AbstractByteArrayOutputStream)baout, ref, new int[]{20, 12});
            Assertions.assertEquals((int)32, (int)written);
            this.checkStreams((AbstractByteArrayOutputStream)baout, ref);
            ((AbstractByteArrayOutputStream)baout).reset();
            ref.reset();
            written = this.writeData((AbstractByteArrayOutputStream)baout, ref, new int[]{5, 47, 33, 60, 1, 0, 8});
            Assertions.assertEquals((int)155, (int)written);
            this.checkStreams((AbstractByteArrayOutputStream)baout, ref);
            ((AbstractByteArrayOutputStream)baout).reset();
            written = ((AbstractByteArrayOutputStream)baout).write(new ByteArrayInputStream(ref.toByteArray()));
            Assertions.assertEquals((int)155, (int)written);
            this.checkStreams((AbstractByteArrayOutputStream)baout, ref);
            try (Object baout1 = baosFactory.newInstance(32);){
                ref.writeTo((OutputStream)baout1);
                java.io.ByteArrayOutputStream ref1 = new java.io.ByteArrayOutputStream();
                ((AbstractByteArrayOutputStream)baout).writeTo(ref1);
                this.checkStreams((AbstractByteArrayOutputStream)baout1, ref1);
                String baoutString = ((AbstractByteArrayOutputStream)baout).toString("ASCII");
                String refString = ref.toString("ASCII");
                Assertions.assertEquals((Object)refString, (Object)baoutString, (String)"ASCII decoded String must be equal");
                try (Object baos1 = baosFactory.newInstance();
                     Object baos2 = baosFactory.newInstance();){
                    Assertions.assertSame((Object)((AbstractByteArrayOutputStream)baos1).toByteArray(), (Object)((AbstractByteArrayOutputStream)baos2).toByteArray());
                }
            }
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"toBufferedInputStreamFunctionFactories"})
    public void testToBufferedInputStream(String baosName, IOFunction<InputStream, InputStream> toBufferedInputStreamFunction) throws IOException {
        byte[] data = new byte[]{-54, -2, -70, -66};
        try (ByteArrayInputStream bain = new ByteArrayInputStream(data);){
            Assertions.assertEquals((int)data.length, (int)bain.available());
            try (InputStream buffered = toBufferedInputStreamFunction.apply(bain);){
                Assertions.assertEquals((int)data.length, (int)buffered.available());
                Assertions.assertArrayEquals((byte[])data, (byte[])IOUtils.toByteArray(buffered));
            }
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"toBufferedInputStreamFunctionFactories"})
    public void testToBufferedInputStreamEmpty(String baosName, IOFunction<InputStream, InputStream> toBufferedInputStreamFunction) throws IOException {
        try (ByteArrayInputStream bain = new ByteArrayInputStream(IOUtils.EMPTY_BYTE_ARRAY);){
            Assertions.assertEquals((int)0, (int)bain.available());
            try (InputStream buffered = toBufferedInputStreamFunction.apply(bain);){
                Assertions.assertEquals((int)0, (int)buffered.available());
            }
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testToInputStream(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();
             java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();){
            this.writeData((AbstractByteArrayOutputStream)baout, ref, 32);
            for (int i = 0; i < 128; ++i) {
                this.writeData((AbstractByteArrayOutputStream)baout, ref, 64);
            }
            try (InputStream in = ((AbstractByteArrayOutputStream)baout).toInputStream();){
                byte[] refData = ref.toByteArray();
                this.writeData((AbstractByteArrayOutputStream)baout, ref, new int[]{2, 4, 8, 16});
                byte[] baoutData = IOUtils.toByteArray(in);
                Assertions.assertEquals((int)8224, (int)baoutData.length);
                this.checkByteArrays(refData, baoutData);
                try (InputStream in2 = ((AbstractByteArrayOutputStream)baout).toInputStream();){
                    baoutData = IOUtils.toByteArray(in2);
                }
                refData = ref.toByteArray();
                Assertions.assertEquals((int)8254, (int)baoutData.length);
                this.checkByteArrays(refData, baoutData);
            }
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testToInputStreamEmpty(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();
             InputStream in = ((AbstractByteArrayOutputStream)baout).toInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            Assertions.assertInstanceOf(ClosedInputStream.class, (Object)in);
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testToInputStreamWithReset(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();
             java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();){
            this.writeData((AbstractByteArrayOutputStream)baout, ref, 32);
            for (int i = 0; i < 128; ++i) {
                this.writeData((AbstractByteArrayOutputStream)baout, ref, 64);
            }
            try (InputStream in = ((AbstractByteArrayOutputStream)baout).toInputStream();){
                byte[] refData = ref.toByteArray();
                ((AbstractByteArrayOutputStream)baout).reset();
                ref.reset();
                this.writeData((AbstractByteArrayOutputStream)baout, ref, new int[]{2, 4, 8, 16});
                byte[] baoutData = IOUtils.toByteArray(in);
                Assertions.assertEquals((int)8224, (int)baoutData.length);
                this.checkByteArrays(refData, baoutData);
                try (InputStream in2 = ((AbstractByteArrayOutputStream)baout).toInputStream();){
                    baoutData = IOUtils.toByteArray(in2);
                }
                refData = ref.toByteArray();
                Assertions.assertEquals((int)30, (int)baoutData.length);
                this.checkByteArrays(refData, baoutData);
            }
        }
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"baosFactories"})
    public void testWriteZero(String baosName, BAOSFactory<?> baosFactory) throws IOException {
        try (Object baout = baosFactory.newInstance();){
            ((AbstractByteArrayOutputStream)baout).write(IOUtils.EMPTY_BYTE_ARRAY, 0, 0);
            Assertions.assertTrue((boolean)true, (String)"Dummy");
        }
    }

    private int writeData(AbstractByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int count) {
        if (count > DATA.length) {
            throw new IllegalArgumentException("Requesting too many bytes");
        }
        if (count == 0) {
            baout.write(100);
            ref.write(100);
            return 1;
        }
        baout.write(DATA, 0, count);
        ref.write(DATA, 0, count);
        return count;
    }

    private int writeData(AbstractByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int[] instructions) {
        int written = 0;
        for (int instruction : instructions) {
            written += this.writeData(baout, ref, instruction);
        }
        return written;
    }

    static {
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            ByteArrayOutputStreamTest.DATA[i] = i;
        }
    }

    private static final class ByteArrayOutputStreamFactory
    implements BAOSFactory<ByteArrayOutputStream> {
        private ByteArrayOutputStreamFactory() {
        }

        @Override
        public ByteArrayOutputStream newInstance() {
            return new ByteArrayOutputStream();
        }

        @Override
        public ByteArrayOutputStream newInstance(int size) {
            return new ByteArrayOutputStream(size);
        }
    }

    private static final class UnsynchronizedByteArrayOutputStreamFactory
    implements BAOSFactory<UnsynchronizedByteArrayOutputStream> {
        private UnsynchronizedByteArrayOutputStreamFactory() {
        }

        @Override
        public UnsynchronizedByteArrayOutputStream newInstance() {
            return new UnsynchronizedByteArrayOutputStream();
        }

        @Override
        public UnsynchronizedByteArrayOutputStream newInstance(int size) {
            return new UnsynchronizedByteArrayOutputStream(size);
        }
    }

    private static interface BAOSFactory<T extends AbstractByteArrayOutputStream> {
        public T newInstance();

        public T newInstance(int var1);
    }
}

