/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.ProxyWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyWriterTest {
    @Test
    public void testAppendChar() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.append('c');
            Assertions.assertEquals((Object)"c", (Object)writer.toString());
        }
    }

    @Test
    public void testAppendCharSequence() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.append("ABC");
            Assertions.assertEquals((Object)"ABC", (Object)writer.toString());
        }
    }

    @Test
    public void testAppendCharSequence_with_offset() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.append("ABC", 1, 3);
            proxy.flush();
            Assertions.assertEquals((Object)"BC", (Object)writer.toString());
        }
    }

    @Test
    public void testExceptions_in_append_char() throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             OutputStreamWriter osw = new OutputStreamWriter(baos){

            @Override
            public void write(int c) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.append('c'));
        }
    }

    @Test
    public void testExceptions_in_append_charSequence() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public Writer append(CharSequence csq) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.append("ABCE"));
        }
    }

    @Test
    public void testExceptions_in_append_charSequence_offset() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.append("ABCE", 1, 2));
        }
    }

    @Test
    public void testExceptions_in_close() {
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> {
            try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    throw new UnsupportedEncodingException("Bah");
                }
            };){
                ProxyWriter proxy = new ProxyWriter(osw);
                proxy.close();
            }
        });
    }

    @Test
    public void testExceptions_in_flush() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void flush() throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, proxy::flush);
        }
    }

    @Test
    public void testExceptions_in_write_char_array() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void write(char[] cbuf) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.write("ABCE".toCharArray()));
        }
    }

    @Test
    public void testExceptions_in_write_int() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void write(int c) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.write(97));
        }
    }

    @Test
    public void testExceptions_in_write_offset_char_array() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.write("ABCE".toCharArray(), 2, 3));
        }
    }

    @Test
    public void testExceptions_in_write_string() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void write(String str) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.write("ABCE"));
        }
    }

    @Test
    public void testExceptions_in_write_string_offset() throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(new ByteArrayOutputStream()){

            @Override
            public void write(String str, int off, int len) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
             ProxyWriter proxy = new ProxyWriter(osw);){
            Assertions.assertThrows(UnsupportedEncodingException.class, () -> proxy.write("ABCE", 1, 3));
        }
    }

    @Test
    public void testNullCharArray() throws Exception {
        try (ProxyWriter proxy = new ProxyWriter(NullWriter.INSTANCE);){
            proxy.write((char[])null);
            proxy.write((char[])null, 0, 0);
        }
    }

    @Test
    public void testNullCharSequence() throws Exception {
        try (ProxyWriter proxy = new ProxyWriter(NullWriter.INSTANCE);){
            proxy.append(null);
        }
    }

    @Test
    public void testNullString() throws Exception {
        try (ProxyWriter proxy = new ProxyWriter(NullWriter.INSTANCE);){
            proxy.write((String)null);
            proxy.write((String)null, 0, 0);
        }
    }

    @Test
    public void testWriteCharArray() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.write(new char[]{'A', 'B', 'C'});
            Assertions.assertEquals((Object)"ABC", (Object)writer.toString());
        }
    }

    @Test
    public void testWriteCharArrayPartial() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.write(new char[]{'A', 'B', 'C'}, 1, 2);
            Assertions.assertEquals((Object)"BC", (Object)writer.toString());
        }
    }

    @Test
    public void testWriteInt() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.write(65);
            Assertions.assertEquals((Object)"A", (Object)writer.toString());
        }
    }

    @Test
    public void testWriteString() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.write("ABC");
            Assertions.assertEquals((Object)"ABC", (Object)writer.toString());
        }
    }

    @Test
    public void testWriteStringPartial() throws Exception {
        try (StringBuilderWriter writer = new StringBuilderWriter();
             ProxyWriter proxy = new ProxyWriter(writer);){
            proxy.write("ABC", 1, 2);
            Assertions.assertEquals((Object)"BC", (Object)writer.toString());
        }
    }
}

