/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThresholdingOutputStreamTest {
    @Test
    public void testSetByteCount_OutputStream() throws Exception {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(3){
            {
                super(threshold);
                this.setByteCount(2L);
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            @Override
            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
    }

    @Test
    public void testSetByteCount_Stream() throws Exception {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(3){
            {
                super(threshold);
                this.setByteCount(2L);
            }

            @Override
            protected OutputStream getStream() throws IOException {
                return new ByteArrayOutputStream(4);
            }

            @Override
            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
    }

    @Test
    public void testThresholdIOConsumer() throws Exception {
        AtomicBoolean reached = new AtomicBoolean();
        reached.set(false);
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, null, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
        }
        reached.set(false);
        tos = new ThresholdingOutputStream(1, os -> reached.set(true), null);
        try {
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
        finally {
            tos.close();
        }
        reached.set(false);
        tos = new ThresholdingOutputStream(1, os -> reached.set(true), os -> new ByteArrayOutputStream(4));
        try {
            tos.write(97);
            Assertions.assertFalse((boolean)reached.get());
            tos.write(97);
            Assertions.assertTrue((boolean)reached.get());
        }
        finally {
            tos.close();
        }
    }

    @Test
    public void testThresholdIOConsumerIOException() throws Exception {
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, os -> {
            throw new IOException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertThrows(IOException.class, () -> tos.write(97));
        }
    }

    @Test
    public void testThresholdIOConsumerUncheckedException() throws Exception {
        try (ThresholdingOutputStream tos = new ThresholdingOutputStream(1, os -> {
            throw new IllegalStateException("Threshold reached.");
        }, os -> new ByteArrayOutputStream(4));){
            tos.write(97);
            Assertions.assertThrows(IllegalStateException.class, () -> tos.write(97));
        }
    }

    @Test
    public void testThresholdLessThanZero() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(-1){

            @Override
            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            Assertions.assertFalse((boolean)reached.get());
            out.write(89);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    public void testThresholdZero() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(0){

            @Override
            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            out.write(89);
            Assertions.assertTrue((boolean)reached.get());
            Assertions.assertTrue((boolean)out.isThresholdExceeded());
        }
    }

    @Test
    public void testThresholdZeroWrite() throws IOException {
        final AtomicBoolean reached = new AtomicBoolean();
        try (ThresholdingOutputStream out = new ThresholdingOutputStream(7){

            @Override
            protected void thresholdReached() throws IOException {
                reached.set(true);
            }
        };){
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertFalse((boolean)reached.get());
            out.write(new byte[0]);
            Assertions.assertFalse((boolean)out.isThresholdExceeded());
            Assertions.assertFalse((boolean)reached.get());
        }
    }
}

