/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.UncheckedAppendable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UncheckedAppendableTest {
    private IOException exception;
    private UncheckedAppendable appendableBroken;
    private UncheckedAppendable appendableString;

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.appendableBroken = UncheckedAppendable.on(new BrokenWriter(this.exception));
        this.appendableString = UncheckedAppendable.on(new StringWriter());
    }

    @Test
    public void testAppendChar() {
        this.appendableString.append('a').append('b');
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    public void testAppendCharSequence() {
        this.appendableString.append("a").append("b");
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    public void testAppendCharSequenceIndexed() {
        this.appendableString.append("a", 0, 1).append("b", 0, 1);
        Assertions.assertEquals((Object)"ab", (Object)this.appendableString.toString());
    }

    @Test
    public void testAppendCharSequenceIndexedThrows() {
        UncheckedIOException e = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append("a", 0, 1));
        Assertions.assertEquals((Object)this.exception, (Object)e.getCause());
    }

    @Test
    public void testAppendCharSequenceThrows() {
        UncheckedIOException e = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append("a"));
        Assertions.assertEquals((Object)this.exception, (Object)e.getCause());
    }

    @Test
    public void testAppendCharThrows() {
        UncheckedIOException e2 = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> this.appendableBroken.append('a'));
        Assertions.assertEquals((Object)this.exception, (Object)e2.getCause());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ab", (Object)UncheckedAppendable.on(new StringWriter(2).append("ab")).toString());
    }
}

