/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.network.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v131.network.model.CertificateTransparencyCompliance;
import org.openqa.selenium.devtools.v131.network.model.SignedCertificateTimestamp;
import org.openqa.selenium.devtools.v131.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v131.security.model.CertificateId;
import org.openqa.selenium.json.JsonInput;

public class SecurityDetails {
    private final String protocol;
    private final String keyExchange;
    private final Optional<String> keyExchangeGroup;
    private final String cipher;
    private final Optional<String> mac;
    private final CertificateId certificateId;
    private final String subjectName;
    private final List<String> sanList;
    private final String issuer;
    private final TimeSinceEpoch validFrom;
    private final TimeSinceEpoch validTo;
    private final List<SignedCertificateTimestamp> signedCertificateTimestampList;
    private final CertificateTransparencyCompliance certificateTransparencyCompliance;
    private final Optional<Integer> serverSignatureAlgorithm;
    private final Boolean encryptedClientHello;

    public SecurityDetails(String protocol, String keyExchange, Optional<String> keyExchangeGroup, String cipher, Optional<String> mac, CertificateId certificateId, String subjectName, List<String> sanList, String issuer, TimeSinceEpoch validFrom, TimeSinceEpoch validTo, List<SignedCertificateTimestamp> signedCertificateTimestampList, CertificateTransparencyCompliance certificateTransparencyCompliance, Optional<Integer> serverSignatureAlgorithm, Boolean encryptedClientHello) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.keyExchange = Objects.requireNonNull(keyExchange, "keyExchange is required");
        this.keyExchangeGroup = keyExchangeGroup;
        this.cipher = Objects.requireNonNull(cipher, "cipher is required");
        this.mac = mac;
        this.certificateId = Objects.requireNonNull(certificateId, "certificateId is required");
        this.subjectName = Objects.requireNonNull(subjectName, "subjectName is required");
        this.sanList = Objects.requireNonNull(sanList, "sanList is required");
        this.issuer = Objects.requireNonNull(issuer, "issuer is required");
        this.validFrom = Objects.requireNonNull(validFrom, "validFrom is required");
        this.validTo = Objects.requireNonNull(validTo, "validTo is required");
        this.signedCertificateTimestampList = Objects.requireNonNull(signedCertificateTimestampList, "signedCertificateTimestampList is required");
        this.certificateTransparencyCompliance = Objects.requireNonNull(certificateTransparencyCompliance, "certificateTransparencyCompliance is required");
        this.serverSignatureAlgorithm = serverSignatureAlgorithm;
        this.encryptedClientHello = Objects.requireNonNull(encryptedClientHello, "encryptedClientHello is required");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyExchange() {
        return this.keyExchange;
    }

    public Optional<String> getKeyExchangeGroup() {
        return this.keyExchangeGroup;
    }

    public String getCipher() {
        return this.cipher;
    }

    public Optional<String> getMac() {
        return this.mac;
    }

    public CertificateId getCertificateId() {
        return this.certificateId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public List<String> getSanList() {
        return this.sanList;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public TimeSinceEpoch getValidFrom() {
        return this.validFrom;
    }

    public TimeSinceEpoch getValidTo() {
        return this.validTo;
    }

    public List<SignedCertificateTimestamp> getSignedCertificateTimestampList() {
        return this.signedCertificateTimestampList;
    }

    public CertificateTransparencyCompliance getCertificateTransparencyCompliance() {
        return this.certificateTransparencyCompliance;
    }

    public Optional<Integer> getServerSignatureAlgorithm() {
        return this.serverSignatureAlgorithm;
    }

    public Boolean getEncryptedClientHello() {
        return this.encryptedClientHello;
    }

    private static SecurityDetails fromJson(JsonInput input) {
        String protocol = null;
        String keyExchange = null;
        Optional<String> keyExchangeGroup = Optional.empty();
        String cipher = null;
        Optional<String> mac = Optional.empty();
        CertificateId certificateId = null;
        String subjectName = null;
        List<String> sanList = null;
        String issuer = null;
        TimeSinceEpoch validFrom = null;
        TimeSinceEpoch validTo = null;
        List<SignedCertificateTimestamp> signedCertificateTimestampList = null;
        CertificateTransparencyCompliance certificateTransparencyCompliance = null;
        Optional<Integer> serverSignatureAlgorithm = Optional.empty();
        Boolean encryptedClientHello = false;
        input.beginObject();
        block34: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = input.nextString();
                    continue block34;
                }
                case "keyExchange": {
                    keyExchange = input.nextString();
                    continue block34;
                }
                case "keyExchangeGroup": {
                    keyExchangeGroup = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "cipher": {
                    cipher = input.nextString();
                    continue block34;
                }
                case "mac": {
                    mac = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "certificateId": {
                    certificateId = (CertificateId)input.read((Type)((Object)CertificateId.class));
                    continue block34;
                }
                case "subjectName": {
                    subjectName = input.nextString();
                    continue block34;
                }
                case "sanList": {
                    sanList = input.readArray((Type)((Object)String.class));
                    continue block34;
                }
                case "issuer": {
                    issuer = input.nextString();
                    continue block34;
                }
                case "validFrom": {
                    validFrom = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block34;
                }
                case "validTo": {
                    validTo = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block34;
                }
                case "signedCertificateTimestampList": {
                    signedCertificateTimestampList = input.readArray((Type)((Object)SignedCertificateTimestamp.class));
                    continue block34;
                }
                case "certificateTransparencyCompliance": {
                    certificateTransparencyCompliance = (CertificateTransparencyCompliance)((Object)input.read((Type)((Object)CertificateTransparencyCompliance.class)));
                    continue block34;
                }
                case "serverSignatureAlgorithm": {
                    serverSignatureAlgorithm = Optional.ofNullable(input.nextNumber().intValue());
                    continue block34;
                }
                case "encryptedClientHello": {
                    encryptedClientHello = input.nextBoolean();
                    continue block34;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SecurityDetails(protocol, keyExchange, keyExchangeGroup, cipher, mac, certificateId, subjectName, sanList, issuer, validFrom, validTo, signedCertificateTimestampList, certificateTransparencyCompliance, serverSignatureAlgorithm, encryptedClientHello);
    }
}

