/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.storage.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v132.storage.model.AttributionReportingFilterPair;
import org.openqa.selenium.devtools.v132.storage.model.SignedInt64AsBase10;
import org.openqa.selenium.devtools.v132.storage.model.UnsignedInt64AsBase10;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingEventTriggerData {
    private final UnsignedInt64AsBase10 data;
    private final SignedInt64AsBase10 priority;
    private final Optional<UnsignedInt64AsBase10> dedupKey;
    private final AttributionReportingFilterPair filters;

    public AttributionReportingEventTriggerData(UnsignedInt64AsBase10 data, SignedInt64AsBase10 priority, Optional<UnsignedInt64AsBase10> dedupKey, AttributionReportingFilterPair filters) {
        this.data = Objects.requireNonNull(data, "data is required");
        this.priority = Objects.requireNonNull(priority, "priority is required");
        this.dedupKey = dedupKey;
        this.filters = Objects.requireNonNull(filters, "filters is required");
    }

    public UnsignedInt64AsBase10 getData() {
        return this.data;
    }

    public SignedInt64AsBase10 getPriority() {
        return this.priority;
    }

    public Optional<UnsignedInt64AsBase10> getDedupKey() {
        return this.dedupKey;
    }

    public AttributionReportingFilterPair getFilters() {
        return this.filters;
    }

    private static AttributionReportingEventTriggerData fromJson(JsonInput input) {
        UnsignedInt64AsBase10 data = null;
        SignedInt64AsBase10 priority = null;
        Optional<UnsignedInt64AsBase10> dedupKey = Optional.empty();
        AttributionReportingFilterPair filters = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "data": {
                    data = (UnsignedInt64AsBase10)input.read((Type)((Object)UnsignedInt64AsBase10.class));
                    continue block12;
                }
                case "priority": {
                    priority = (SignedInt64AsBase10)input.read((Type)((Object)SignedInt64AsBase10.class));
                    continue block12;
                }
                case "dedupKey": {
                    dedupKey = Optional.ofNullable((UnsignedInt64AsBase10)input.read((Type)((Object)UnsignedInt64AsBase10.class)));
                    continue block12;
                }
                case "filters": {
                    filters = (AttributionReportingFilterPair)input.read((Type)((Object)AttributionReportingFilterPair.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingEventTriggerData(data, priority, dedupKey, filters);
    }
}

