/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.webauthn;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v132.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.v132.webauthn.model.Credential;
import org.openqa.selenium.devtools.v132.webauthn.model.CredentialAdded;
import org.openqa.selenium.devtools.v132.webauthn.model.CredentialAsserted;
import org.openqa.selenium.devtools.v132.webauthn.model.CredentialDeleted;
import org.openqa.selenium.devtools.v132.webauthn.model.CredentialUpdated;
import org.openqa.selenium.devtools.v132.webauthn.model.VirtualAuthenticatorOptions;

@Beta
public class WebAuthn {
    public static Command<Void> enable(Optional<Boolean> enableUI) {
        LinkedHashMap params = new LinkedHashMap();
        enableUI.ifPresent(p -> params.put("enableUI", p));
        return new Command<Void>("WebAuthn.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("WebAuthn.disable", Map.copyOf(params));
    }

    public static Command<AuthenticatorId> addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        Objects.requireNonNull(options, "options is required");
        LinkedHashMap<String, VirtualAuthenticatorOptions> params = new LinkedHashMap<String, VirtualAuthenticatorOptions>();
        params.put("options", options);
        return new Command<AuthenticatorId>("WebAuthn.addVirtualAuthenticator", Map.copyOf(params), ConverterFunctions.map("authenticatorId", AuthenticatorId.class));
    }

    public static Command<Void> setResponseOverrideBits(AuthenticatorId authenticatorId, Optional<Boolean> isBogusSignature, Optional<Boolean> isBadUV, Optional<Boolean> isBadUP) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, AuthenticatorId> params = new LinkedHashMap<String, AuthenticatorId>();
        params.put("authenticatorId", authenticatorId);
        isBogusSignature.ifPresent(p -> params.put("isBogusSignature", (AuthenticatorId)p));
        isBadUV.ifPresent(p -> params.put("isBadUV", (AuthenticatorId)p));
        isBadUP.ifPresent(p -> params.put("isBadUP", (AuthenticatorId)p));
        return new Command<Void>("WebAuthn.setResponseOverrideBits", Map.copyOf(params));
    }

    public static Command<Void> removeVirtualAuthenticator(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, AuthenticatorId> params = new LinkedHashMap<String, AuthenticatorId>();
        params.put("authenticatorId", authenticatorId);
        return new Command<Void>("WebAuthn.removeVirtualAuthenticator", Map.copyOf(params));
    }

    public static Command<Void> addCredential(AuthenticatorId authenticatorId, Credential credential) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credential, "credential is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("credential", credential);
        return new Command<Void>("WebAuthn.addCredential", Map.copyOf(params));
    }

    public static Command<Credential> getCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<Credential>("WebAuthn.getCredential", Map.copyOf(params), ConverterFunctions.map("credential", Credential.class));
    }

    public static Command<List<Credential>> getCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, AuthenticatorId> params = new LinkedHashMap<String, AuthenticatorId>();
        params.put("authenticatorId", authenticatorId);
        return new Command<List<Credential>>("WebAuthn.getCredentials", Map.copyOf(params), ConverterFunctions.map("credentials", input -> input.readArray((Type)((Object)Credential.class))));
    }

    public static Command<Void> removeCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        return new Command<Void>("WebAuthn.removeCredential", Map.copyOf(params));
    }

    public static Command<Void> clearCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        LinkedHashMap<String, AuthenticatorId> params = new LinkedHashMap<String, AuthenticatorId>();
        params.put("authenticatorId", authenticatorId);
        return new Command<Void>("WebAuthn.clearCredentials", Map.copyOf(params));
    }

    public static Command<Void> setUserVerified(AuthenticatorId authenticatorId, Boolean isUserVerified) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(isUserVerified, "isUserVerified is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("isUserVerified", isUserVerified);
        return new Command<Void>("WebAuthn.setUserVerified", Map.copyOf(params));
    }

    public static Command<Void> setAutomaticPresenceSimulation(AuthenticatorId authenticatorId, Boolean enabled) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("enabled", enabled);
        return new Command<Void>("WebAuthn.setAutomaticPresenceSimulation", Map.copyOf(params));
    }

    public static Command<Void> setCredentialProperties(AuthenticatorId authenticatorId, String credentialId, Optional<Boolean> backupEligibility, Optional<Boolean> backupState) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("authenticatorId", authenticatorId);
        params.put("credentialId", credentialId);
        backupEligibility.ifPresent(p -> params.put("backupEligibility", p));
        backupState.ifPresent(p -> params.put("backupState", p));
        return new Command<Void>("WebAuthn.setCredentialProperties", Map.copyOf(params));
    }

    public static Event<CredentialAdded> credentialAdded() {
        return new Event<CredentialAdded>("WebAuthn.credentialAdded", input -> (CredentialAdded)input.read((Type)((Object)CredentialAdded.class)));
    }

    public static Event<CredentialDeleted> credentialDeleted() {
        return new Event<CredentialDeleted>("WebAuthn.credentialDeleted", input -> (CredentialDeleted)input.read((Type)((Object)CredentialDeleted.class)));
    }

    public static Event<CredentialUpdated> credentialUpdated() {
        return new Event<CredentialUpdated>("WebAuthn.credentialUpdated", input -> (CredentialUpdated)input.read((Type)((Object)CredentialUpdated.class)));
    }

    public static Event<CredentialAsserted> credentialAsserted() {
        return new Event<CredentialAsserted>("WebAuthn.credentialAsserted", input -> (CredentialAsserted)input.read((Type)((Object)CredentialAsserted.class)));
    }
}

