/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.browser;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v133.browser.model.Bounds;
import org.openqa.selenium.devtools.v133.browser.model.BrowserCommandId;
import org.openqa.selenium.devtools.v133.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v133.browser.model.DownloadProgress;
import org.openqa.selenium.devtools.v133.browser.model.DownloadWillBegin;
import org.openqa.selenium.devtools.v133.browser.model.Histogram;
import org.openqa.selenium.devtools.v133.browser.model.PermissionDescriptor;
import org.openqa.selenium.devtools.v133.browser.model.PermissionSetting;
import org.openqa.selenium.devtools.v133.browser.model.PermissionType;
import org.openqa.selenium.devtools.v133.browser.model.WindowID;
import org.openqa.selenium.devtools.v133.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class Browser {
    @Beta
    public static Command<Void> setPermission(PermissionDescriptor permission, PermissionSetting setting, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permission, "permission is required");
        Objects.requireNonNull(setting, "setting is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("permission", permission);
        params.put("setting", (Object)setting);
        origin.ifPresent(p -> params.put("origin", p));
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Browser.setPermission", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> grantPermissions(List<PermissionType> permissions, Optional<String> origin, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(permissions, "permissions is required");
        LinkedHashMap<String, List<PermissionType>> params = new LinkedHashMap<String, List<PermissionType>>();
        params.put("permissions", permissions);
        origin.ifPresent(p -> params.put("origin", (List<PermissionType>)p));
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<PermissionType>)p));
        return new Command<Void>("Browser.grantPermissions", Map.copyOf(params));
    }

    public static Command<Void> resetPermissions(Optional<BrowserContextID> browserContextId) {
        LinkedHashMap params = new LinkedHashMap();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Browser.resetPermissions", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDownloadBehavior(SetDownloadBehaviorBehavior behavior, Optional<BrowserContextID> browserContextId, Optional<String> downloadPath, Optional<Boolean> eventsEnabled) {
        Objects.requireNonNull(behavior, "behavior is required");
        LinkedHashMap<String, SetDownloadBehaviorBehavior> params = new LinkedHashMap<String, SetDownloadBehaviorBehavior>();
        params.put("behavior", behavior);
        browserContextId.ifPresent(p -> params.put("browserContextId", (SetDownloadBehaviorBehavior)((Object)p)));
        downloadPath.ifPresent(p -> params.put("downloadPath", (SetDownloadBehaviorBehavior)((Object)p)));
        eventsEnabled.ifPresent(p -> params.put("eventsEnabled", (SetDownloadBehaviorBehavior)((Object)p)));
        return new Command<Void>("Browser.setDownloadBehavior", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> cancelDownload(String guid, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(guid, "guid is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("guid", guid);
        browserContextId.ifPresent(p -> params.put("browserContextId", (String)p));
        return new Command<Void>("Browser.cancelDownload", Map.copyOf(params));
    }

    public static Command<Void> close() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Browser.close", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> crash() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Browser.crash", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> crashGpuProcess() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("Browser.crashGpuProcess", Map.copyOf(params));
    }

    public static Command<GetVersionResponse> getVersion() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<GetVersionResponse>("Browser.getVersion", Map.copyOf(params), input -> (GetVersionResponse)input.read((Type)((Object)GetVersionResponse.class)));
    }

    @Beta
    public static Command<List<String>> getBrowserCommandLine() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<List<String>>("Browser.getBrowserCommandLine", Map.copyOf(params), ConverterFunctions.map("arguments", input -> input.readArray((Type)((Object)String.class))));
    }

    @Beta
    public static Command<List<Histogram>> getHistograms(Optional<String> query, Optional<Boolean> delta) {
        LinkedHashMap params = new LinkedHashMap();
        query.ifPresent(p -> params.put("query", p));
        delta.ifPresent(p -> params.put("delta", p));
        return new Command<List<Histogram>>("Browser.getHistograms", Map.copyOf(params), ConverterFunctions.map("histograms", input -> input.readArray((Type)((Object)Histogram.class))));
    }

    @Beta
    public static Command<Histogram> getHistogram(String name, Optional<Boolean> delta) {
        Objects.requireNonNull(name, "name is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", name);
        delta.ifPresent(p -> params.put("delta", (String)p));
        return new Command<Histogram>("Browser.getHistogram", Map.copyOf(params), ConverterFunctions.map("histogram", Histogram.class));
    }

    @Beta
    public static Command<Bounds> getWindowBounds(WindowID windowId) {
        Objects.requireNonNull(windowId, "windowId is required");
        LinkedHashMap<String, WindowID> params = new LinkedHashMap<String, WindowID>();
        params.put("windowId", windowId);
        return new Command<Bounds>("Browser.getWindowBounds", Map.copyOf(params), ConverterFunctions.map("bounds", Bounds.class));
    }

    @Beta
    public static Command<GetWindowForTargetResponse> getWindowForTarget(Optional<TargetID> targetId) {
        LinkedHashMap params = new LinkedHashMap();
        targetId.ifPresent(p -> params.put("targetId", p));
        return new Command<GetWindowForTargetResponse>("Browser.getWindowForTarget", Map.copyOf(params), input -> (GetWindowForTargetResponse)input.read((Type)((Object)GetWindowForTargetResponse.class)));
    }

    @Beta
    public static Command<Void> setWindowBounds(WindowID windowId, Bounds bounds) {
        Objects.requireNonNull(windowId, "windowId is required");
        Objects.requireNonNull(bounds, "bounds is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("windowId", windowId);
        params.put("bounds", bounds);
        return new Command<Void>("Browser.setWindowBounds", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> setDockTile(Optional<String> badgeLabel, Optional<String> image) {
        LinkedHashMap params = new LinkedHashMap();
        badgeLabel.ifPresent(p -> params.put("badgeLabel", p));
        image.ifPresent(p -> params.put("image", p));
        return new Command<Void>("Browser.setDockTile", Map.copyOf(params));
    }

    @Beta
    public static Command<Void> executeBrowserCommand(BrowserCommandId commandId) {
        Objects.requireNonNull(commandId, "commandId is required");
        LinkedHashMap<String, BrowserCommandId> params = new LinkedHashMap<String, BrowserCommandId>();
        params.put("commandId", commandId);
        return new Command<Void>("Browser.executeBrowserCommand", Map.copyOf(params));
    }

    public static Command<Void> addPrivacySandboxEnrollmentOverride(String url) {
        Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url);
        return new Command<Void>("Browser.addPrivacySandboxEnrollmentOverride", Map.copyOf(params));
    }

    public static Event<DownloadWillBegin> downloadWillBegin() {
        return new Event<DownloadWillBegin>("Browser.downloadWillBegin", input -> (DownloadWillBegin)input.read((Type)((Object)DownloadWillBegin.class)));
    }

    public static Event<DownloadProgress> downloadProgress() {
        return new Event<DownloadProgress>("Browser.downloadProgress", input -> (DownloadProgress)input.read((Type)((Object)DownloadProgress.class)));
    }

    public static class GetWindowForTargetResponse {
        private final WindowID windowId;
        private final Bounds bounds;

        public GetWindowForTargetResponse(WindowID windowId, Bounds bounds) {
            this.windowId = Objects.requireNonNull(windowId, "windowId is required");
            this.bounds = Objects.requireNonNull(bounds, "bounds is required");
        }

        public WindowID getWindowId() {
            return this.windowId;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        private static GetWindowForTargetResponse fromJson(JsonInput input) {
            WindowID windowId = null;
            Bounds bounds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "windowId": {
                        windowId = (WindowID)input.read((Type)((Object)WindowID.class));
                        continue block8;
                    }
                    case "bounds": {
                        bounds = (Bounds)input.read((Type)((Object)Bounds.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetWindowForTargetResponse(windowId, bounds);
        }
    }

    public static class GetVersionResponse {
        private final String protocolVersion;
        private final String product;
        private final String revision;
        private final String userAgent;
        private final String jsVersion;

        public GetVersionResponse(String protocolVersion, String product, String revision, String userAgent, String jsVersion) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is required");
            this.product = Objects.requireNonNull(product, "product is required");
            this.revision = Objects.requireNonNull(revision, "revision is required");
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent is required");
            this.jsVersion = Objects.requireNonNull(jsVersion, "jsVersion is required");
        }

        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        public String getProduct() {
            return this.product;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getJsVersion() {
            return this.jsVersion;
        }

        private static GetVersionResponse fromJson(JsonInput input) {
            String protocolVersion = null;
            String product = null;
            String revision = null;
            String userAgent = null;
            String jsVersion = null;
            input.beginObject();
            block14: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "protocolVersion": {
                        protocolVersion = input.nextString();
                        continue block14;
                    }
                    case "product": {
                        product = input.nextString();
                        continue block14;
                    }
                    case "revision": {
                        revision = input.nextString();
                        continue block14;
                    }
                    case "userAgent": {
                        userAgent = input.nextString();
                        continue block14;
                    }
                    case "jsVersion": {
                        jsVersion = input.nextString();
                        continue block14;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetVersionResponse(protocolVersion, product, revision, userAgent, jsVersion);
        }
    }

    public static enum SetDownloadBehaviorBehavior {
        DENY("deny"),
        ALLOW("allow"),
        ALLOWANDNAME("allowAndName"),
        DEFAULT("default");

        private String value;

        private SetDownloadBehaviorBehavior(String value) {
            this.value = value;
        }

        public static SetDownloadBehaviorBehavior fromString(String s2) {
            return Arrays.stream(SetDownloadBehaviorBehavior.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetDownloadBehaviorBehavior "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetDownloadBehaviorBehavior fromJson(JsonInput input) {
            return SetDownloadBehaviorBehavior.fromString(input.nextString());
        }
    }
}

